/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.gui;

import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.GUIHolder;
import me.hsgamer.hscore.minecraft.gui.InventoryGUIDisplay;
import me.hsgamer.hscore.minecraft.gui.object.Item;
import me.hsgamer.hscore.minestom.gui.MinestomGUIHolder;
import me.hsgamer.hscore.minestom.gui.inventory.DelegatingInventory;
import me.hsgamer.hscore.minestom.gui.object.MinestomItem;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinestomGUIDisplay
extends InventoryGUIDisplay<MinestomGUIHolder> {
    private DelegatingInventory inventory;

    public MinestomGUIDisplay(@NotNull UUID uuid, @NotNull MinestomGUIHolder holder) {
        super(uuid, (GUIHolder)holder);
    }

    protected void initInventory() {
        this.inventory = new DelegatingInventory(((MinestomGUIHolder)this.holder).getInventoryType(), ((MinestomGUIHolder)this.holder).getTitleFunction().apply(this.uuid), this);
        this.inventory.init();
    }

    protected void clearInventory() {
        if (this.inventory != null) {
            this.inventory.stop();
        }
    }

    protected int getInventorySize() {
        return this.inventory == null ? 0 : this.inventory.getSize();
    }

    protected void setButton(int slot, @Nullable Item item) {
        if (item == null) {
            this.inventory.setItemStack(slot, ItemStack.AIR);
        } else if (item instanceof MinestomItem) {
            MinestomItem minestomItem = (MinestomItem)item;
            this.inventory.setItemStack(slot, minestomItem.itemStack());
        }
    }

    public void open() {
        Player player = MinecraftServer.getConnectionManager().getOnlinePlayerByUuid(this.uuid);
        if (player != null) {
            player.openInventory((Inventory)this.inventory);
        }
    }

    @Nullable
    public DelegatingInventory getInventory() {
        return this.inventory;
    }
}

