/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.gui;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import me.hsgamer.hscore.minecraft.gui.GUIHolder;
import me.hsgamer.hscore.minecraft.gui.GUIProperties;
import me.hsgamer.hscore.minestom.gui.MinestomGUIDisplay;
import me.hsgamer.hscore.minestom.gui.event.MinestomCloseEvent;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public class MinestomGUIHolder
extends GUIHolder<MinestomGUIDisplay> {
    private InventoryType inventoryType = InventoryType.CHEST_3_ROW;
    private Function<UUID, Component> titleFunction = uuid -> Component.empty();
    private Predicate<UUID> closePredicate = uuid -> true;

    @NotNull
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(@NotNull InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    @NotNull
    public @NotNull Function<@NotNull UUID, @NotNull Component> getTitleFunction() {
        return this.titleFunction;
    }

    public void setTitleFunction(Function<@NotNull UUID, @NotNull Component> titleFunction) {
        this.titleFunction = titleFunction;
    }

    @NotNull
    public Component getTitle(@NotNull UUID uuid) {
        return this.titleFunction.apply(uuid);
    }

    public void setTitle(@NotNull Component title) {
        this.setTitleFunction(uuid -> title);
    }

    @NotNull
    public @NotNull Predicate<@NotNull UUID> getClosePredicate() {
        return this.closePredicate;
    }

    public void setClosePredicate(@NotNull @NotNull Predicate<@NotNull UUID> closePredicate) {
        this.closePredicate = closePredicate;
    }

    public void init() {
        this.addEventConsumer(MinestomCloseEvent.class, event -> {
            UUID uuid = event.getViewerID();
            if (this.closePredicate != null && !this.closePredicate.test(uuid)) {
                event.setRemoveDisplay(false);
                InventoryCloseEvent inventoryCloseEvent = (InventoryCloseEvent)event.getEvent();
                inventoryCloseEvent.setNewInventory(inventoryCloseEvent.getInventory());
            }
        });
        super.init();
    }

    @NotNull
    protected MinestomGUIDisplay newDisplay(UUID uuid) {
        return new MinestomGUIDisplay(uuid, this);
    }

    protected void closeAll(List<MinestomGUIDisplay> displays) {
        displays.stream().map(MinestomGUIDisplay::getInventory).filter(Objects::nonNull).forEach(inventory -> inventory.getViewers().forEach(Player::closeInventory));
    }

    static {
        GUIProperties.setMillisPerTick((long)MinecraftServer.TICK_MS);
    }
}

