/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.gui;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.hscore.minecraft.gui.common.item.ActionItem;
import me.hsgamer.hscore.minecraft.gui.holder.GUIHolder;
import me.hsgamer.hscore.minestom.gui.MinestomInventoryContext;
import me.hsgamer.hscore.minestom.gui.event.MinestomClickEvent;
import me.hsgamer.hscore.minestom.gui.event.MinestomCloseEvent;
import me.hsgamer.hscore.minestom.gui.event.MinestomOpenEvent;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.event.inventory.InventoryOpenEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.event.trait.InventoryEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MinestomGUIHolder
extends GUIHolder<MinestomInventoryContext> {
    private final EventNode<InventoryEvent> eventNode;
    private final Function<UUID, Inventory> inventoryFunction;

    public MinestomGUIHolder(UUID viewerID, Function<UUID, Inventory> inventoryFunction) {
        super(viewerID);
        this.inventoryFunction = inventoryFunction;
        this.eventNode = EventNode.event((String)("inventory-" + String.valueOf(UUID.randomUUID())), (EventFilter)EventFilter.INVENTORY, event -> Objects.equals(event.getInventory(), ((MinestomInventoryContext)this.getInventoryContext()).getInventory()));
        this.eventNode.addListener(InventoryOpenEvent.class, event -> this.handleOpen(new MinestomOpenEvent((InventoryOpenEvent)event)));
        this.eventNode.addListener(InventoryPreClickEvent.class, event -> {
            boolean wasCancelled = event.isCancelled();
            event.setCancelled(true);
            this.handleClick(new MinestomClickEvent((InventoryPreClickEvent)event));
            if (!wasCancelled && !event.isCancelled()) {
                event.setCancelled(false);
            }
        });
        this.eventNode.addListener(InventoryCloseEvent.class, event -> this.handleClose(new MinestomCloseEvent((InventoryCloseEvent)event)));
    }

    protected MinestomInventoryContext createInventoryContext() {
        return new MinestomInventoryContext(this.getViewerID(), this.inventoryFunction.apply(this.getViewerID()));
    }

    protected void setItem(int slot, @Nullable ActionItem item) {
        Object i = item != null ? item.getItem() : null;
        ((MinestomInventoryContext)this.getInventoryContext()).getInventory().setItemStack(slot, i instanceof ItemStack ? (ItemStack)i : ItemStack.AIR);
    }

    public void open(UUID uuid) {
        Player player = MinecraftServer.getConnectionManager().getOnlinePlayerByUuid(uuid);
        if (player != null) {
            player.openInventory(((MinestomInventoryContext)this.getInventoryContext()).getInventory());
        }
    }

    public void init() {
        super.init();
        MinecraftServer.getGlobalEventHandler().addChild(this.eventNode);
    }

    public void stop() {
        super.stop();
        MinecraftServer.getGlobalEventHandler().removeChild(this.eventNode);
    }
}

