/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.request;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionRequestManager<T, V> {
    private final Map<UUID, BiFunction<UUID, T, V>> cache = new ConcurrentHashMap<UUID, BiFunction<UUID, T, V>>();

    public void addRequest(@NotNull UUID uuid, @NotNull BiFunction<UUID, T, V> function) {
        this.cache.put(uuid, function);
    }

    public void addRequest(@NotNull UUID uuid, @NotNull Function<T, V> function) {
        this.addRequest(uuid, (UUID uuid1, T t) -> function.apply(t));
    }

    @Nullable
    public V apply(@NotNull UUID uuid, @NotNull T arg) {
        if (this.cache.containsKey(uuid)) {
            return this.cache.remove(uuid).apply(uuid, (UUID)arg);
        }
        return null;
    }

    public void remove(@NotNull UUID uuid) {
        this.cache.remove(uuid);
    }

    public boolean contains(@NotNull UUID uuid) {
        return this.cache.containsKey(uuid);
    }
}

