/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.request;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;

public class RequestManager<I, D> {
    private final Map<I, Queue<CompletableFuture<D>>> requests = new HashMap<I, Queue<CompletableFuture<D>>>();

    public CompletableFuture<D> addRequest(I identifier) {
        CompletableFuture dataFuture = new CompletableFuture();
        this.requests.computeIfAbsent(identifier, k -> new ArrayDeque()).add(dataFuture);
        return dataFuture;
    }

    public void removeRequests(I identifier) {
        Queue<CompletableFuture<D>> queue = this.requests.remove(identifier);
        if (queue == null) {
            return;
        }
        queue.forEach(future -> future.cancel(true));
        queue.clear();
    }

    public void removeRequest(I identifier) {
        Queue<CompletableFuture<D>> queue = this.requests.get(identifier);
        if (queue == null) {
            return;
        }
        CompletableFuture<D> future = queue.poll();
        if (future != null) {
            future.cancel(true);
        }
    }

    public void completeRequest(I identifier, D data, boolean handleAll) {
        Queue<CompletableFuture<D>> queue = this.requests.get(identifier);
        if (queue == null) {
            return;
        }
        if (handleAll) {
            queue.forEach(future -> future.complete(data));
            queue.clear();
        } else {
            CompletableFuture<D> future2 = queue.poll();
            if (future2 != null) {
                future2.complete(data);
            }
        }
    }

    public void completeRequest(I identifier, D data) {
        this.completeRequest(identifier, data, false);
    }
}

