/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.serializer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.hsgamer.hscore.serializer.annotation.SerializerInputFunction;
import me.hsgamer.hscore.serializer.annotation.SerializerOutputFunction;
import me.hsgamer.hscore.serializer.annotation.SerializerType;

public class Serializer<I, O> {
    private final List<Entry<I, O>> entryList = new ArrayList<Entry<I, O>>();

    public <T extends O> Serializer<I, O> register(String type, Class<T> outputClass, Function<I, T> outputFunction, Function<T, I> inputFunction) {
        this.entryList.add(new Entry(type, outputClass, outputFunction::apply, input -> inputFunction.apply(outputClass.cast(input))));
        return this;
    }

    public <T extends O> Serializer<I, O> register(Class<T> outputClass, Function<I, T> outputFunction, Function<T, I> inputFunction) {
        String type = outputClass.isAnnotationPresent(SerializerType.class) ? outputClass.getAnnotation(SerializerType.class).value() : outputClass.getName();
        return this.register(type, outputClass, outputFunction, inputFunction);
    }

    public <T extends O> Serializer<I, O> register(Class<T> outputClass) {
        Method outputMethod = null;
        Method inputMethod = null;
        for (Method method : outputClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(SerializerInputFunction.class)) {
                inputMethod = method;
                continue;
            }
            if (!method.isAnnotationPresent(SerializerOutputFunction.class)) continue;
            outputMethod = method;
        }
        if (outputMethod == null) {
            throw new IllegalArgumentException("Cannot find the output method");
        }
        if (outputMethod.getParameterCount() != 1) {
            throw new IllegalArgumentException("The output method must have 1 parameter");
        }
        if (!outputClass.isAssignableFrom(outputMethod.getReturnType())) {
            throw new IllegalArgumentException("The output method must return a type that is an instance of " + outputClass.getName());
        }
        if (!Modifier.isPublic(outputMethod.getModifiers())) {
            throw new IllegalArgumentException("The output method must be public");
        }
        if (!Modifier.isStatic(outputMethod.getModifiers())) {
            throw new IllegalArgumentException("The output method must be static");
        }
        if (inputMethod == null) {
            throw new IllegalArgumentException("Cannot find the input method");
        }
        if (inputMethod.getParameterCount() != 0) {
            throw new IllegalArgumentException("The input method must have 0 parameter");
        }
        if (!Modifier.isPublic(inputMethod.getModifiers())) {
            throw new IllegalArgumentException("The input method must be public");
        }
        if (Modifier.isStatic(inputMethod.getModifiers())) {
            throw new IllegalArgumentException("The input method must not be static");
        }
        Method finalOutputMethod = outputMethod;
        Method finalInputMethod = inputMethod;
        Function<Object, Object> outputFunction = input -> {
            try {
                return outputClass.cast(finalOutputMethod.invoke(null, input));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Function<Object, Object> inputFunction = output -> {
            try {
                return finalInputMethod.invoke(output, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return this.register(outputClass, outputFunction, inputFunction);
    }

    public Serializer<I, O> unregister(String type) {
        this.entryList.removeIf(entry -> ((Entry)entry).type.equals(type));
        return this;
    }

    public Serializer<I, O> unregister(Class<? extends O> outputClass) {
        this.entryList.removeIf(entry -> ((Entry)entry).outputClass.equals(outputClass));
        return this;
    }

    public O deserialize(String type, I input) {
        return (O)this.entryList.stream().filter(entry -> ((Entry)entry).type.equals(type)).findFirst().map(entry -> ((Entry)entry).outputFunction.apply(input)).orElseThrow(() -> new IllegalArgumentException("Cannot find the type: " + type));
    }

    public Map.Entry<String, I> serialize(O output) {
        return this.entryList.stream().filter(entry -> ((Entry)entry).outputClass.isInstance(output)).findFirst().map(entry -> new AbstractMap.SimpleEntry(((Entry)entry).type, ((Entry)entry).inputFunction.apply(output))).orElseThrow(() -> new IllegalArgumentException("Cannot find the type for class: " + output.getClass().getName()));
    }

    public Map<String, Class<? extends O>> getRegisteredTypes() {
        return this.entryList.stream().collect(Collectors.toMap(entry -> ((Entry)entry).type, entry -> ((Entry)entry).outputClass, (a, b) -> a));
    }

    private static class Entry<I, O> {
        private final String type;
        private final Class<? extends O> outputClass;
        private final Function<I, O> outputFunction;
        private final Function<O, I> inputFunction;

        private Entry(String type, Class<? extends O> outputClass, Function<I, O> outputFunction, Function<O, I> inputFunction) {
            this.type = type;
            this.outputClass = outputClass;
            this.outputFunction = outputFunction;
            this.inputFunction = inputFunction;
        }
    }
}

