/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.serializer;

import java.util.Map;
import me.hsgamer.hscore.serializer.Serializer;

public abstract class DataConverter<F, T, I, O> {
    private final Serializer<I, O> serializer = this.createSerializer();

    protected DataConverter() {
    }

    protected abstract Serializer<I, O> createSerializer();

    protected abstract T convertTo(O var1, F var2);

    protected abstract F convertFrom(I var1, String var2, T var3);

    protected abstract O getOutput(T var1);

    protected abstract I getInput(F var1);

    protected abstract String getType(F var1);

    public T deserialize(F from) {
        I input = this.getInput(from);
        String type = this.getType(from);
        O data = this.serializer.deserialize(type, input);
        return this.convertTo(data, from);
    }

    public F serialize(T to) {
        O output = this.getOutput(to);
        Map.Entry<String, I> entry = this.serializer.serialize(output);
        return this.convertFrom(entry.getValue(), entry.getKey(), to);
    }

    public Serializer<I, O> getSerializer() {
        return this.serializer;
    }
}

