/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.serializer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.hsgamer.hscore.serializer.annotation.SerializerInputFunction;
import me.hsgamer.hscore.serializer.annotation.SerializerOutputFunction;
import me.hsgamer.hscore.serializer.annotation.SerializerType;

public class Serializer<I, O> {
    private final Map<String, Entry<I, O>> typeEntryMap = new HashMap<String, Entry<I, O>>();
    private final Map<Class<? extends O>, Entry<I, O>> classEntryMap = new IdentityHashMap<Class<? extends O>, Entry<I, O>>();

    public <T extends O> Serializer<I, O> register(String type, Class<T> outputClass, Function<I, T> outputFunction, Function<T, I> inputFunction) {
        if (this.typeEntryMap.containsKey(type)) {
            throw new IllegalArgumentException("The type is already registered: " + type);
        }
        if (this.classEntryMap.containsKey(outputClass)) {
            throw new IllegalArgumentException("The class is already registered: " + outputClass.getName());
        }
        Entry entry = new Entry(type, outputClass, outputFunction::apply, input -> inputFunction.apply(outputClass.cast(input)));
        this.typeEntryMap.put(type, entry);
        this.classEntryMap.put(outputClass, entry);
        return this;
    }

    public <T extends O> Serializer<I, O> register(Class<T> outputClass, Function<I, T> outputFunction, Function<T, I> inputFunction) {
        String type = outputClass.isAnnotationPresent(SerializerType.class) ? outputClass.getAnnotation(SerializerType.class).value() : outputClass.getName();
        return this.register(type, outputClass, outputFunction, inputFunction);
    }

    public <T extends O> Serializer<I, O> register(Class<T> outputClass) {
        Method outputMethod = null;
        Method inputMethod = null;
        for (Method method : outputClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(SerializerInputFunction.class)) {
                inputMethod = method;
                continue;
            }
            if (!method.isAnnotationPresent(SerializerOutputFunction.class)) continue;
            outputMethod = method;
        }
        if (outputMethod == null) {
            throw new IllegalArgumentException("Cannot find the output method");
        }
        if (outputMethod.getParameterCount() != 1) {
            throw new IllegalArgumentException("The output method must have 1 parameter");
        }
        if (!outputClass.isAssignableFrom(outputMethod.getReturnType())) {
            throw new IllegalArgumentException("The output method must return a type that is an instance of " + outputClass.getName());
        }
        if (!Modifier.isPublic(outputMethod.getModifiers())) {
            throw new IllegalArgumentException("The output method must be public");
        }
        if (!Modifier.isStatic(outputMethod.getModifiers())) {
            throw new IllegalArgumentException("The output method must be static");
        }
        if (inputMethod == null) {
            throw new IllegalArgumentException("Cannot find the input method");
        }
        if (inputMethod.getParameterCount() != 0) {
            throw new IllegalArgumentException("The input method must have 0 parameter");
        }
        if (!Modifier.isPublic(inputMethod.getModifiers())) {
            throw new IllegalArgumentException("The input method must be public");
        }
        if (Modifier.isStatic(inputMethod.getModifiers())) {
            throw new IllegalArgumentException("The input method must not be static");
        }
        Method finalOutputMethod = outputMethod;
        Method finalInputMethod = inputMethod;
        Function<Object, Object> outputFunction = input -> {
            try {
                return outputClass.cast(finalOutputMethod.invoke(null, input));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Function<Object, Object> inputFunction = output -> {
            try {
                return finalInputMethod.invoke(output, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return this.register(outputClass, outputFunction, inputFunction);
    }

    public Serializer<I, O> unregister(String type) {
        Entry<I, O> entry = this.typeEntryMap.remove(type);
        if (entry != null) {
            this.classEntryMap.remove(((Entry)entry).outputClass);
        }
        return this;
    }

    public Serializer<I, O> unregister(Class<? extends O> outputClass) {
        Entry<I, O> entry = this.classEntryMap.remove(outputClass);
        if (entry != null) {
            this.typeEntryMap.remove(((Entry)entry).type);
        }
        return this;
    }

    public O deserialize(String type, I input) {
        Entry<I, O> entry = this.typeEntryMap.get(type);
        if (entry == null) {
            throw new IllegalArgumentException("Cannot find the type: " + type);
        }
        return (O)((Entry)entry).outputFunction.apply(input);
    }

    public Map.Entry<String, I> serialize(O output) {
        Class<?> outputClass = output.getClass();
        Entry<I, O> entry = this.classEntryMap.get(outputClass);
        if (entry == null) {
            throw new IllegalArgumentException("Cannot find the type for class: " + output.getClass().getName());
        }
        return new AbstractMap.SimpleEntry(((Entry)entry).type, ((Entry)entry).inputFunction.apply(output));
    }

    public Map<String, Class<? extends O>> getRegisteredTypes() {
        return Collections.unmodifiableMap(this.typeEntryMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Entry)entry.getValue()).outputClass)));
    }

    private static class Entry<I, O> {
        private final String type;
        private final Class<? extends O> outputClass;
        private final Function<I, O> outputFunction;
        private final Function<O, I> inputFunction;

        private Entry(String type, Class<? extends O> outputClass, Function<I, O> outputFunction, Function<O, I> inputFunction) {
            this.type = type;
            this.outputClass = outputClass;
            this.outputFunction = outputFunction;
            this.inputFunction = inputFunction;
        }
    }
}

