/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.task;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class BatchRunnable
implements Runnable {
    private final Queue<TaskPool> tasks = new PriorityQueue<TaskPool>(Comparator.comparingInt(TaskPool::getStage));
    private final Map<String, Object> data;
    private long timeout = 0L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;

    public BatchRunnable(Map<String, Object> data) {
        this.data = data;
    }

    public BatchRunnable() {
        this(new HashMap<String, Object>());
    }

    @Override
    public void run() {
        final AtomicBoolean isRunning = new AtomicBoolean(true);
        final AtomicReference<TaskPool> currentTaskPool = new AtomicReference<TaskPool>();
        final AtomicReference nextLock = new AtomicReference();
        Process process = new Process(){

            @Override
            public Map<String, Object> getData() {
                return BatchRunnable.this.data;
            }

            @Override
            public void next() {
                Optional.ofNullable((CompletableFuture)nextLock.get()).ifPresent(future -> future.complete(null));
            }

            @Override
            public void complete() {
                isRunning.set(false);
                this.next();
            }

            @Override
            public TaskPool getCurrentTaskPool() {
                return (TaskPool)currentTaskPool.get();
            }

            @Override
            public TaskPool getTaskPool(int stage) {
                return BatchRunnable.this.getTaskPool(stage);
            }
        };
        block3: while (isRunning.get()) {
            Consumer<Process> task;
            TaskPool taskPool = this.tasks.poll();
            if (taskPool == null) {
                isRunning.set(false);
                break;
            }
            currentTaskPool.set(taskPool);
            while ((task = taskPool.pollTask()) != null) {
                CompletableFuture next = new CompletableFuture();
                nextLock.set(next);
                task.accept(process);
                try {
                    if (this.timeout > 0L) {
                        next.get(this.timeout, this.timeoutUnit);
                    } else {
                        next.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    isRunning.set(false);
                    continue block3;
                }
                catch (ExecutionException | TimeoutException e) {
                    throw new BatchRunnableException(e);
                }
                if (isRunning.get()) continue;
                continue block3;
            }
        }
    }

    public TaskPool getTaskPool(int stage) {
        TaskPool taskPool = null;
        for (TaskPool t : this.tasks) {
            if (t.getStage() != stage) continue;
            taskPool = t;
            break;
        }
        if (taskPool == null) {
            taskPool = new TaskPool(stage);
            this.tasks.add(taskPool);
        }
        return taskPool;
    }

    public void addTaskPool(int stage, Consumer<TaskPool> taskPoolConsumer) {
        taskPoolConsumer.accept(this.getTaskPool(stage));
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static final class TaskPool {
        private final int stage;
        private final Deque<Consumer<Process>> tasks = new ArrayDeque<Consumer<Process>>();

        private TaskPool(int stage) {
            this.stage = stage;
        }

        public TaskPool addFirst(Consumer<Process> task) {
            this.tasks.addFirst(task);
            return this;
        }

        public TaskPool addLast(Consumer<Process> task) {
            this.tasks.addLast(task);
            return this;
        }

        public TaskPool addFirst(Runnable ... task) {
            for (Runnable t : task) {
                this.tasks.addFirst(process -> {
                    t.run();
                    process.next();
                });
            }
            return this;
        }

        public TaskPool addLast(Runnable ... task) {
            for (Runnable t : task) {
                this.tasks.addLast(process -> {
                    t.run();
                    process.next();
                });
            }
            return this;
        }

        Consumer<Process> pollTask() {
            return this.tasks.poll();
        }

        int getStage() {
            return this.stage;
        }
    }

    public static class BatchRunnableException
    extends RuntimeException {
        private BatchRunnableException(Throwable cause) {
            super(cause);
        }
    }

    public static interface Process {
        public Map<String, Object> getData();

        public void next();

        public void complete();

        public TaskPool getCurrentTaskPool();

        public TaskPool getTaskPool(int var1);

        default public void addTaskPool(int stage, Consumer<TaskPool> taskPoolConsumer) {
            taskPoolConsumer.accept(this.getTaskPool(stage));
        }

        default public void addCurrentTaskPool(Consumer<TaskPool> taskPoolConsumer) {
            taskPoolConsumer.accept(this.getCurrentTaskPool());
        }
    }
}

