/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.task;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.hsgamer.hscore.task.element.TaskPool;
import me.hsgamer.hscore.task.element.TaskProcess;
import me.hsgamer.hscore.task.exception.BatchRunnableException;

public class BatchRunnable
implements Runnable {
    private final Queue<TaskPool> tasks = new PriorityQueue<TaskPool>(Comparator.comparingInt(TaskPool::getStage));
    private final Map<String, Object> data;
    private long timeout = 0L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;

    public BatchRunnable(Map<String, Object> data) {
        this.data = data;
    }

    public BatchRunnable() {
        this(new ConcurrentHashMap<String, Object>());
    }

    @Override
    public void run() {
        final AtomicBoolean isRunning = new AtomicBoolean(true);
        final AtomicReference<TaskPool> currentTaskPool = new AtomicReference<TaskPool>();
        final AtomicReference nextLock = new AtomicReference();
        TaskProcess process = new TaskProcess(){

            @Override
            public Map<String, Object> getData() {
                return BatchRunnable.this.data;
            }

            @Override
            public void next() {
                Optional.ofNullable((CompletableFuture)nextLock.get()).ifPresent(future -> future.complete(null));
            }

            @Override
            public void complete() {
                isRunning.set(false);
                this.next();
            }

            @Override
            public TaskPool getCurrentTaskPool() {
                return (TaskPool)currentTaskPool.get();
            }

            @Override
            public TaskPool getTaskPool(int stage) {
                return BatchRunnable.this.getTaskPool(stage);
            }
        };
        block3: while (isRunning.get()) {
            Consumer<TaskProcess> task;
            TaskPool taskPool = this.tasks.poll();
            if (taskPool == null) {
                isRunning.set(false);
                break;
            }
            currentTaskPool.set(taskPool);
            while ((task = taskPool.pollTask()) != null) {
                CompletableFuture next = new CompletableFuture();
                nextLock.set(next);
                task.accept(process);
                try {
                    if (this.timeout > 0L) {
                        next.get(this.timeout, this.timeoutUnit);
                    } else {
                        next.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    isRunning.set(false);
                    continue block3;
                }
                catch (ExecutionException | TimeoutException e) {
                    throw new BatchRunnableException(e);
                }
                if (isRunning.get()) continue;
                continue block3;
            }
        }
    }

    public TaskPool getTaskPool(int stage) {
        TaskPool taskPool = null;
        for (TaskPool t : this.tasks) {
            if (t.getStage() != stage) continue;
            taskPool = t;
            break;
        }
        if (taskPool == null) {
            taskPool = new TaskPool(stage);
            this.tasks.add(taskPool);
        }
        return taskPool;
    }

    public void addTaskPool(int stage, Consumer<TaskPool> taskPoolConsumer) {
        taskPoolConsumer.accept(this.getTaskPool(stage));
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

