/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.ui;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.hsgamer.hscore.ui.Display;
import me.hsgamer.hscore.ui.Holder;
import me.hsgamer.hscore.ui.property.Updatable;

public abstract class BaseHolder<D extends Display>
implements Holder<D> {
    protected final Map<UUID, D> displayMap = new ConcurrentHashMap<UUID, D>();
    private final Map<Class<?>, List<Consumer<Object>>> classListMap = new HashMap();

    protected abstract D newDisplay(UUID var1);

    protected void onRemoveDisplay(D display) {
    }

    @Override
    public D createDisplay(UUID uuid) {
        return (D)this.displayMap.computeIfAbsent(uuid, uuid1 -> {
            D display = this.newDisplay((UUID)uuid1);
            display.init();
            return display;
        });
    }

    @Override
    public void removeDisplay(UUID uuid) {
        Optional.ofNullable((Display)this.displayMap.remove(uuid)).ifPresent(display -> {
            this.onRemoveDisplay(display);
            display.stop();
        });
    }

    @Override
    public void removeAllDisplay() {
        this.displayMap.values().forEach(display -> {
            this.onRemoveDisplay(display);
            display.stop();
        });
        this.displayMap.clear();
    }

    @Override
    public Optional<D> getDisplay(UUID uuid) {
        return Optional.ofNullable((Display)this.displayMap.get(uuid));
    }

    @Override
    public void update() {
        this.displayMap.values().forEach(Updatable::update);
    }

    @Override
    public <T> void addEventConsumer(Class<T> eventClass, Consumer<T> eventConsumer) {
        this.classListMap.computeIfAbsent(eventClass, clazz -> new LinkedList()).add(o -> eventConsumer.accept(eventClass.cast(o)));
    }

    @Override
    public void stop() {
        this.clearAllEventConsumer();
        this.removeAllDisplay();
    }

    @Override
    public void clearEventConsumer(Class<?> eventClass) {
        this.classListMap.remove(eventClass);
    }

    @Override
    public void clearAllEventConsumer() {
        this.classListMap.clear();
    }

    @Override
    public void handleEvent(Object event) {
        Optional.ofNullable(this.classListMap.get(event.getClass())).ifPresent(list -> list.forEach(consumer -> consumer.accept(event)));
    }
}

