/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.hsgamer.hscore.ui.Display;
import me.hsgamer.hscore.ui.property.Initializable;
import me.hsgamer.hscore.ui.property.Updatable;
import org.jetbrains.annotations.NotNull;

public interface Holder<D extends Display>
extends Initializable,
Updatable {
    @NotNull
    public D createDisplay(@NotNull UUID var1);

    public void removeDisplay(@NotNull UUID var1);

    public Optional<@NotNull D> getDisplay(@NotNull UUID var1);

    public <T> void addEventConsumer(@NotNull Class<T> var1, @NotNull Consumer<T> var2);

    public void clearEventConsumer(@NotNull Class<?> var1);

    public void clearAllEventConsumer();

    public void removeAllDisplay();

    public void handleEvent(@NotNull Class<?> var1, @NotNull Object var2);

    default public <E> void handleEvent(@NotNull E event) {
        HashSet<Class> eventClassSet = new HashSet<Class>();
        LinkedList eventClassQueue = new LinkedList();
        for (Class<?> eventClass = event.getClass(); eventClass != null && !Object.class.equals(eventClass); eventClass = eventClass.getSuperclass()) {
            Class currentClass;
            eventClassSet.add(eventClass);
            this.handleEvent(eventClass, event);
            eventClassQueue.addAll(Arrays.asList(eventClass.getInterfaces()));
            while ((currentClass = (Class)eventClassQueue.poll()) != null && eventClassSet.add(currentClass)) {
                this.handleEvent(currentClass, event);
                eventClassQueue.addAll(Arrays.asList(currentClass.getInterfaces()));
            }
        }
    }
}

