/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.hsgamer.hscore.ui.Display;
import me.hsgamer.hscore.ui.property.Initializable;
import me.hsgamer.hscore.ui.property.Updatable;
import org.jetbrains.annotations.NotNull;

public interface Holder<D extends Display>
extends Initializable,
Updatable {
    @NotNull
    public D createDisplay(@NotNull UUID var1);

    public void removeDisplay(@NotNull UUID var1);

    public Optional<@NotNull D> getDisplay(@NotNull UUID var1);

    public <T> void addEventConsumer(@NotNull Class<T> var1, @NotNull Consumer<T> var2);

    public void clearEventConsumer(@NotNull Class<?> var1);

    public void clearAllEventConsumer();

    public void removeAllDisplay();

    public void handleEvent(@NotNull Class<?> var1, @NotNull Object var2);

    default public <E> void handleEvent(@NotNull E event) {
        Class currentClass;
        HashSet<Class> eventClassSet = new HashSet<Class>();
        LinkedList eventClassQueue = new LinkedList();
        eventClassQueue.add(event.getClass());
        while ((currentClass = (Class)eventClassQueue.poll()) != null) {
            if (!eventClassSet.add(currentClass)) continue;
            this.handleEvent(currentClass, event);
            Optional.ofNullable(currentClass.getSuperclass()).ifPresent(eventClassQueue::add);
            eventClassQueue.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
    }

    default public void update(UUID uuid) {
        this.getDisplay(uuid).ifPresent(Updatable::update);
    }
}

