/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.hsgamer.hscore.ui.Display;
import me.hsgamer.hscore.ui.Holder;
import me.hsgamer.hscore.ui.property.Updatable;
import org.jetbrains.annotations.NotNull;

public abstract class BaseHolder<D extends Display>
implements Holder<D> {
    protected final Map<UUID, D> displayMap = new ConcurrentHashMap<UUID, D>();
    private final Map<Class<?>, List<Consumer<Object>>> classListMap = new HashMap();

    @NotNull
    protected abstract D newDisplay(UUID var1);

    protected void onRemoveDisplay(@NotNull D display) {
    }

    @Override
    @NotNull
    public D createDisplay(@NotNull UUID uuid) {
        return (D)this.displayMap.computeIfAbsent(uuid, uuid1 -> {
            D display = this.newDisplay((UUID)uuid1);
            display.init();
            return display;
        });
    }

    @Override
    public void removeDisplay(@NotNull UUID uuid) {
        Optional.ofNullable((Display)this.displayMap.remove(uuid)).ifPresent(display -> {
            this.onRemoveDisplay(display);
            display.stop();
        });
    }

    @Override
    public void removeAllDisplay() {
        this.displayMap.values().forEach(display -> {
            this.onRemoveDisplay(display);
            display.stop();
        });
        this.displayMap.clear();
    }

    @Override
    public Optional<@NotNull D> getDisplay(@NotNull UUID uuid) {
        return Optional.ofNullable((Display)this.displayMap.get(uuid));
    }

    @Override
    public void update() {
        this.displayMap.values().forEach(Updatable::update);
    }

    @Override
    public void stop() {
        this.clearAllEventConsumer();
        this.removeAllDisplay();
    }

    public <T> void addEventConsumer(@NotNull Class<T> eventClass, @NotNull Consumer<T> eventConsumer) {
        this.classListMap.computeIfAbsent(eventClass, clazz -> new ArrayList()).add(o -> eventConsumer.accept(eventClass.cast(o)));
    }

    public void clearEventConsumer(@NotNull Class<?> eventClass) {
        this.classListMap.remove(eventClass);
    }

    public void clearAllEventConsumer() {
        this.classListMap.clear();
    }

    public void handleEvent(@NotNull Class<?> eventClass, @NotNull Object event) {
        if (!this.classListMap.containsKey(eventClass)) {
            return;
        }
        if (!eventClass.isInstance(event)) {
            throw new IllegalArgumentException("The event is not an instance of " + eventClass.getName());
        }
        this.classListMap.get(eventClass).forEach(consumer -> consumer.accept(event));
    }

    @Override
    public <E> void handleEvent(@NotNull E event) {
        Class currentClass;
        HashSet<Class> eventClassSet = new HashSet<Class>();
        LinkedList eventClassQueue = new LinkedList();
        eventClassQueue.add(event.getClass());
        while ((currentClass = (Class)eventClassQueue.poll()) != null) {
            if (!eventClassSet.add(currentClass)) continue;
            this.handleEvent(currentClass, event);
            Optional.ofNullable(currentClass.getSuperclass()).ifPresent(eventClassQueue::add);
            eventClassQueue.addAll(Arrays.asList(currentClass.getInterfaces()));
        }
    }
}

