/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.minigamecore.bukkit;

import me.hsgamer.minigamecore.base.Arena;
import me.hsgamer.minigamecore.base.ArenaManager;
import me.hsgamer.minigamecore.base.GameState;
import me.hsgamer.minigamecore.base.extra.TimePeriod;
import me.hsgamer.minigamecore.bukkit.event.ArenaChangeStateEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class BukkitArena
extends Arena
implements TimePeriod {
    private BukkitTask task;

    protected BukkitArena(String name, ArenaManager arenaManager) {
        super(name, arenaManager);
    }

    public abstract boolean isAsync();

    protected void initArena() {
        JavaPlugin plugin = JavaPlugin.getProvidingPlugin(((Object)((Object)this)).getClass());
        this.task = this.isAsync() ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)((Object)this), this.getDelay(), this.getPeriod()) : Bukkit.getScheduler().runTaskTimer((Plugin)plugin, (Runnable)((Object)this), this.getDelay(), this.getPeriod());
    }

    protected void clearArena() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    protected boolean callStateChanged(GameState oldStage, GameState newStage) {
        ArenaChangeStateEvent event = new ArenaChangeStateEvent(this, oldStage, newStage);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }
}

