/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.minigamecore.manager;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.hsgamer.minigamecore.base.Arena;
import me.hsgamer.minigamecore.base.FeatureUnit;

public abstract class ArenaManager
extends FeatureUnit {
    private final List<Arena> arenaList = new LinkedList<Arena>();

    public ArenaManager(FeatureUnit parentFeatureUnit) {
        super(parentFeatureUnit);
    }

    public ArenaManager() {
    }

    public void postInit() {
        super.postInit();
        this.arenaList.forEach(Arena::postInit);
    }

    public void clear() {
        this.clearAllArenas();
        super.clear();
    }

    public Optional<Arena> getArenaByName(String name) {
        return this.arenaList.parallelStream().filter(arena -> arena.getName().equals(name)).findFirst();
    }

    public List<Arena> getAllArenas() {
        return Collections.unmodifiableList(this.arenaList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public boolean addArena(Arena arena) {
        if (!arena.isValid()) {
            return false;
        }
        arena.init();
        this.arenaList.add(arena);
        return true;
    }

    public void removeArena(Arena arena) {
        if (this.arenaList.remove(arena)) {
            arena.clear();
        }
    }

    public void clearAllArenas() {
        this.arenaList.forEach(arena -> {
            if (arena == null) {
                return;
            }
            arena.clear();
        });
        this.arenaList.clear();
    }
}

