/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.minigamecore.manager;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.hsgamer.minigamecore.base.Arena;
import me.hsgamer.minigamecore.base.FeatureUnit;

public abstract class ArenaManager
extends FeatureUnit {
    private final Map<String, Arena> arenaMap = new HashMap<String, Arena>();

    public ArenaManager(List<FeatureUnit> parentList) {
        super(parentList);
    }

    public ArenaManager(FeatureUnit ... parent) {
        super(parent);
    }

    public void postInit() {
        super.postInit();
        this.arenaMap.values().forEach(Arena::postInit);
    }

    public void clear() {
        this.clearAllArenas();
        super.clear();
    }

    public Optional<Arena> getArenaByName(String name) {
        return Optional.ofNullable(this.arenaMap.get(name));
    }

    public List<Arena> getAllArenas() {
        return new ArrayList<Arena>(this.arenaMap.values());
    }

    public boolean addArena(Arena arena) {
        String name = arena.getName();
        if (this.arenaMap.containsKey(name)) {
            return false;
        }
        if (!arena.isValid()) {
            return false;
        }
        arena.init();
        this.arenaMap.put(name, arena);
        return true;
    }

    public void removeArena(Arena arena) {
        Arena removed = this.arenaMap.remove(arena.getName());
        if (removed != null) {
            removed.clear();
        }
    }

    public void removeArena(String name) {
        Arena removed = this.arenaMap.remove(name);
        if (removed != null) {
            removed.clear();
        }
    }

    public void clearAllArenas() {
        this.arenaMap.values().forEach(arena -> {
            if (arena == null) {
                return;
            }
            arena.clear();
        });
        this.arenaMap.clear();
    }

    public <T extends Arena> Optional<T> createArena(String name, Class<T> arenaClass, Consumer<T> onCreateConsumer) {
        Constructor<T> constructor2;
        Arena arena = null;
        try {
            constructor2 = arenaClass.getConstructor(String.class, ((Object)((Object)this)).getClass());
            arena = (Arena)constructor2.newInstance(new Object[]{name, this});
        }
        catch (Exception constructor2) {
            // empty catch block
        }
        try {
            constructor2 = arenaClass.getConstructor(String.class, FeatureUnit.class);
            arena = (Arena)constructor2.newInstance(new Object[]{name, this});
        }
        catch (Exception constructor3) {
            // empty catch block
        }
        if (arena == null) {
            try {
                constructor2 = arenaClass.getConstructor(String.class);
                arena = (Arena)constructor2.newInstance(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arena == null) {
            return Optional.empty();
        }
        onCreateConsumer.accept(arena);
        if (this.addArena(arena)) {
            return Optional.of(arena);
        }
        return Optional.empty();
    }
}

