/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.minigamecore.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import me.hsgamer.minigamecore.base.Arena;
import me.hsgamer.minigamecore.base.FeatureUnit;
import me.hsgamer.minigamecore.manager.ManagedArena;

public abstract class ArenaManager<T, A extends Arena>
extends FeatureUnit {
    private final Map<T, A> arenaMap = new HashMap<T, A>();

    public ArenaManager(List<FeatureUnit> parentList) {
        super(parentList);
    }

    public ArenaManager(FeatureUnit ... parent) {
        super(parent);
    }

    public void postInit() {
        super.postInit();
        this.arenaMap.values().forEach(rec$ -> ((Arena)rec$).postInit());
    }

    public void clear() {
        this.clearAllArenas();
        super.clear();
    }

    public boolean containsArena(T identifier) {
        return this.arenaMap.containsKey(identifier);
    }

    public Optional<A> getArena(T identifier) {
        return Optional.ofNullable((Arena)this.arenaMap.get(identifier));
    }

    public Map<T, A> getArenaMap() {
        return Collections.unmodifiableMap(this.arenaMap);
    }

    public Collection<A> getAllArenas() {
        return Collections.unmodifiableCollection(this.arenaMap.values());
    }

    public boolean addArena(A arena) {
        Object identifier = ((ManagedArena)arena).getIdentifier();
        if (this.arenaMap.containsKey(identifier)) {
            return false;
        }
        if (!arena.isValid()) {
            return false;
        }
        arena.init();
        this.arenaMap.put(identifier, arena);
        return true;
    }

    public void removeArena(T identifier) {
        Arena removed = (Arena)this.arenaMap.remove(identifier);
        if (removed != null) {
            removed.clear();
        }
    }

    public void clearAllArenas() {
        this.arenaMap.values().forEach(arena -> {
            if (arena == null) {
                return;
            }
            arena.clear();
        });
        this.arenaMap.clear();
    }

    public Optional<A> createArena(T identifier, Function<T, A> arenaCreator, Consumer<A> onCreateConsumer) {
        if (this.containsArena(identifier)) {
            return Optional.empty();
        }
        Arena arena = (Arena)arenaCreator.apply(identifier);
        if (arena == null) {
            return Optional.empty();
        }
        onCreateConsumer.accept(arena);
        if (this.addArena(arena)) {
            return Optional.of(arena);
        }
        return Optional.empty();
    }
}

