/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.core;

import java.util.List;
import java.util.function.Consumer;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.data.core.DataEntry;
import me.hsgamer.topper.data.core.DataHolder;

public interface AgentHolder<K, V>
extends DataHolder<K, V> {
    public List<Agent> getAgents();

    public List<DataEntryAgent<K, V>> getEntryAgents();

    default public void onCreate(DataEntry<K, V> entry) {
        this.getEntryAgents().forEach(agent -> agent.onCreate(entry));
    }

    default public void onRemove(DataEntry<K, V> entry) {
        this.getEntryAgents().forEach(agent -> agent.onRemove(entry));
    }

    default public void onUpdate(DataEntry<K, V> entry, V oldValue, V newValue) {
        this.getEntryAgents().forEach(agent -> agent.onUpdate(entry, oldValue, newValue));
    }

    default public void register() {
        this.getAgents().forEach(Agent::start);
    }

    default public void unregister() {
        Consumer<Consumer> reverseRunnable = consumer -> {
            List<Agent> agentList = this.getAgents();
            for (int i = agentList.size() - 1; i >= 0; --i) {
                Agent agent = agentList.get(i);
                consumer.accept(agent);
            }
        };
        reverseRunnable.accept(Agent::beforeStop);
        List entryAgentList = this.getEntryAgents();
        this.getEntryMap().values().forEach(entry -> entryAgentList.forEach(agent -> agent.onUnregister(entry)));
        reverseRunnable.accept(Agent::stop);
    }
}

