/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.holder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;

public class AgentDataHolder<K, V>
extends DataHolder<K, V> {
    private final List<Agent> agentList = new ArrayList<Agent>();
    private final List<DataEntryAgent<K, V>> entryAgentList = new ArrayList<DataEntryAgent<K, V>>();

    public AgentDataHolder(String name) {
        super(name);
    }

    public void addAgent(Agent agent) {
        this.agentList.add(agent);
    }

    public void addEntryAgent(DataEntryAgent<K, V> entryAgent) {
        this.entryAgentList.add(entryAgent);
    }

    public void removeAgent(Agent agent) {
        this.agentList.remove(agent);
    }

    public void removeEntryAgent(DataEntryAgent<K, V> entryAgent) {
        this.entryAgentList.remove(entryAgent);
    }

    protected final void onCreate(DataEntry<K, V> entry) {
        this.entryAgentList.forEach(agent -> agent.onCreate(entry));
    }

    protected void onUpdate(DataEntry<K, V> entry, V oldValue, V newValue) {
        this.entryAgentList.forEach(agent -> agent.onUpdate(entry, oldValue, newValue));
    }

    protected final void onRemove(DataEntry<K, V> entry) {
        this.entryAgentList.forEach(agent -> agent.onRemove(entry));
    }

    public final void register() {
        this.agentList.forEach(Agent::start);
    }

    public final void unregister() {
        Consumer<Consumer> reverseRunnable = consumer -> {
            for (int i = this.agentList.size() - 1; i >= 0; --i) {
                Agent agent = this.agentList.get(i);
                consumer.accept(agent);
            }
        };
        reverseRunnable.accept(Agent::beforeStop);
        this.getEntryMap().values().forEach(entry -> this.entryAgentList.forEach(agent -> agent.onUnregister(entry)));
        this.clear();
        reverseRunnable.accept(Agent::stop);
    }
}

