/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.snapshot;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;

public abstract class SnapshotAgent<K, V>
implements Agent,
Runnable {
    private final AtomicReference<List<Map.Entry<K, V>>> entryList = new AtomicReference(Collections.emptyList());
    private final AtomicReference<Map<K, Integer>> indexMap = new AtomicReference(Collections.emptyMap());
    private final List<Predicate<Map.Entry<K, V>>> filters = new ArrayList<Predicate<Map.Entry<K, V>>>();
    private Comparator<V> comparator;

    public static <K, V> SnapshotAgent<K, V> create(final DataHolder<K, V> holder) {
        return new SnapshotAgent<K, V>(){

            @Override
            protected Stream<Map.Entry<K, V>> getDataStream() {
                return holder.getEntryMap().entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), ((DataEntry)entry.getValue()).getValue()));
            }
        };
    }

    protected abstract Stream<Map.Entry<K, V>> getDataStream();

    @Override
    public void run() {
        List list = this.getUrgentSnapshot();
        this.entryList.set(this.getUrgentSnapshot());
        Map<Object, Integer> map = IntStream.range(0, list.size()).boxed().collect(Collectors.toMap(i -> ((Map.Entry)list.get((int)i)).getKey(), i -> i));
        this.indexMap.set(map);
    }

    public void stop() {
        this.entryList.set(Collections.emptyList());
        this.indexMap.set(Collections.emptyMap());
    }

    public List<Map.Entry<K, V>> getUrgentSnapshot() {
        Stream<Map.Entry> stream = this.getDataStream().filter(snapshot -> this.filters.stream().allMatch(filter -> filter.test(snapshot)));
        if (this.comparator != null) {
            stream = stream.sorted(Map.Entry.comparingByValue(this.comparator));
        }
        return stream.collect(Collectors.toList());
    }

    public List<Map.Entry<K, V>> getSnapshot() {
        return this.entryList.get();
    }

    public int getSnapshotIndex(K key) {
        return this.indexMap.get().getOrDefault(key, -1);
    }

    public Optional<Map.Entry<K, V>> getSnapshotByIndex(int index) {
        List<Map.Entry<K, V>> list = this.getSnapshot();
        if (index < 0 || index >= list.size()) {
            return Optional.empty();
        }
        return Optional.of(list.get(index));
    }

    public void setComparator(Comparator<V> comparator) {
        this.comparator = comparator;
    }

    public void addFilter(Predicate<Map.Entry<K, V>> filter) {
        this.filters.add(filter);
    }
}

