/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.storage.simple.builder;

import java.io.File;
import java.util.function.Supplier;
import me.hsgamer.hscore.builder.Builder;
import me.hsgamer.topper.agent.storage.simple.converter.FlatEntryConverter;
import me.hsgamer.topper.agent.storage.simple.converter.SqlEntryConverter;
import me.hsgamer.topper.agent.storage.simple.setting.DatabaseSetting;
import me.hsgamer.topper.agent.storage.simple.supplier.DataStorageSupplier;
import me.hsgamer.topper.agent.storage.simple.supplier.FlatStorageSupplier;
import me.hsgamer.topper.agent.storage.simple.supplier.MySqlStorageSupplier;
import me.hsgamer.topper.agent.storage.simple.supplier.NewSqliteStorageSupplier;
import me.hsgamer.topper.agent.storage.simple.supplier.SqliteStorageSupplier;

public class DataStorageBuilder<K, V>
extends Builder<Void, DataStorageSupplier<K, V>> {
    private final File holderBaseFolder;
    private final FlatEntryConverter<K, V> flatEntryConverter;
    private final SqlEntryConverter<K, V> sqlEntryConverter;
    private final Supplier<DataStorageSupplier<K, V>> defaultSupplier;

    public DataStorageBuilder(Supplier<DatabaseSetting> databaseSettingSupplier, File holderBaseFolder, FlatEntryConverter<K, V> flatEntryConverter, SqlEntryConverter<K, V> sqlEntryConverter) {
        this.holderBaseFolder = holderBaseFolder;
        this.flatEntryConverter = flatEntryConverter;
        this.sqlEntryConverter = sqlEntryConverter;
        this.defaultSupplier = () -> new FlatStorageSupplier(holderBaseFolder, flatEntryConverter);
        this.register(this.defaultSupplier, new String[]{"flat", "properties", ""});
        this.register(v -> new SqliteStorageSupplier((DatabaseSetting)databaseSettingSupplier.get(), holderBaseFolder, sqlEntryConverter), new String[]{"sqlite", "sqlite3"});
        this.register(v -> new NewSqliteStorageSupplier((DatabaseSetting)databaseSettingSupplier.get(), holderBaseFolder, sqlEntryConverter), new String[]{"new-sqlite", "new-sqlite3"});
        this.register(v -> new MySqlStorageSupplier((DatabaseSetting)databaseSettingSupplier.get(), sqlEntryConverter), new String[]{"mysql", "mysql-connector-java", "mysql-connector"});
    }

    public DataStorageSupplier<K, V> buildSupplier(String type) {
        return this.build(type, null).orElseGet(this.defaultSupplier);
    }

    public File getHolderBaseFolder() {
        return this.holderBaseFolder;
    }

    public FlatEntryConverter<K, V> getFlatEntryConverter() {
        return this.flatEntryConverter;
    }

    public SqlEntryConverter<K, V> getSqlEntryConverter() {
        return this.sqlEntryConverter;
    }
}

