/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.storage.simple.supplier;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.agent.storage.DataStorage;
import me.hsgamer.topper.agent.storage.simple.converter.FlatEntryConverter;
import me.hsgamer.topper.agent.storage.simple.supplier.DataStorageSupplier;

public class FlatStorageSupplier<K, V>
implements DataStorageSupplier<K, V> {
    private final Logger logger = LoggerProvider.getLogger(this.getClass());
    private final File holderBaseFolder;
    private final FlatEntryConverter<K, V> converter;

    public FlatStorageSupplier(File holderBaseFolder, FlatEntryConverter<K, V> converter) {
        this.holderBaseFolder = holderBaseFolder;
        this.converter = converter;
    }

    @Override
    public DataStorage<K, V> getStorage(String name) {
        final Properties properties = new Properties();
        File file = new File(this.holderBaseFolder, name + ".properties");
        final Runnable loadRunnable = () -> {
            try {
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileInputStream fileOutputStream = new FileInputStream(file);){
                    properties.load(fileOutputStream);
                }
            }
            catch (IOException e) {
                this.logger.log(LogLevel.ERROR, "Failed to load the data", (Throwable)e);
            }
        };
        final Runnable saveRunnable = () -> {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                properties.store(fileOutputStream, "Data for " + name);
            }
            catch (IOException e) {
                this.logger.log(LogLevel.ERROR, "Failed to save the data", (Throwable)e);
            }
        };
        return new DataStorage<K, V>(){

            public Map<K, V> load() {
                HashMap map = new HashMap();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    Object k = FlatStorageSupplier.this.converter.toKey(key.toString());
                    Object v = FlatStorageSupplier.this.converter.toValue(value.toString());
                    map.put(k, v);
                }));
                return map;
            }

            public CompletableFuture<Void> save(Map<K, V> map, boolean urgent) {
                Runnable runnable = () -> {
                    map.forEach((k, v) -> properties.put(FlatStorageSupplier.this.converter.toRawKey(k), FlatStorageSupplier.this.converter.toRawValue(v)));
                    saveRunnable.run();
                };
                if (urgent) {
                    runnable.run();
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.runAsync(runnable);
            }

            public CompletableFuture<Optional<V>> load(K key, boolean urgent) {
                Supplier<Optional> runnable = () -> Optional.ofNullable(properties.getProperty(FlatStorageSupplier.this.converter.toRawKey(key))).map(FlatStorageSupplier.this.converter::toValue);
                if (urgent) {
                    return CompletableFuture.completedFuture(runnable.get());
                }
                return CompletableFuture.supplyAsync(runnable);
            }

            public void onRegister() {
                loadRunnable.run();
            }

            public void onUnregister() {
                saveRunnable.run();
            }
        };
    }
}

