/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.storage.simple.supplier;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.hsgamer.hscore.database.client.sql.BatchBuilder;
import me.hsgamer.hscore.database.client.sql.StatementBuilder;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.agent.storage.DataStorage;
import me.hsgamer.topper.agent.storage.simple.converter.SqlEntryConverter;
import me.hsgamer.topper.agent.storage.simple.supplier.DataStorageSupplier;
import org.intellij.lang.annotations.Language;

public abstract class SqlStorageSupplier<K, V>
implements DataStorageSupplier<K, V> {
    protected final Logger logger = LoggerProvider.getLogger(this.getClass());
    private final SqlEntryConverter<K, V> converter;

    protected SqlStorageSupplier(SqlEntryConverter<K, V> converter) {
        this.converter = converter;
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void flushConnection(Connection var1);

    @Language(value="SQL")
    protected abstract String toSaveStatement(String var1, String[] var2, String[] var3);

    protected abstract Object[] toSaveValues(Object[] var1, Object[] var2);

    @Override
    public DataStorage<K, V> getStorage(final String name) {
        return new DataStorage<K, V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<K, V> load() {
                Connection connection = null;
                try {
                    connection = SqlStorageSupplier.this.getConnection();
                    Map<Object, Object> map = StatementBuilder.create((Connection)connection).setStatement("SELECT * FROM `" + name + "`;").queryList(resultSet -> new AbstractMap.SimpleEntry(SqlStorageSupplier.this.converter.getKey(resultSet), SqlStorageSupplier.this.converter.getValue(resultSet))).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    return map;
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load top holder", (Throwable)e);
                    Map map = Collections.emptyMap();
                    return map;
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }

            public CompletableFuture<Void> save(Map<K, V> map, boolean urgent) {
                Runnable runnable = () -> {
                    Connection connection = null;
                    try {
                        connection = SqlStorageSupplier.this.getConnection();
                        String[] keyColumns = SqlStorageSupplier.this.converter.getKeyColumns();
                        String[] valueColumns = SqlStorageSupplier.this.converter.getValueColumns();
                        String statement = SqlStorageSupplier.this.toSaveStatement(name, keyColumns, valueColumns);
                        BatchBuilder batchBuilder = BatchBuilder.create((Connection)connection, (String)statement);
                        map.forEach((key, value) -> {
                            Object[] keyQueryValues = SqlStorageSupplier.this.converter.toKeyQueryValues(key);
                            Object[] valueQueryValues = SqlStorageSupplier.this.converter.toValueQueryValues(value);
                            Object[] queryValues = SqlStorageSupplier.this.toSaveValues(keyQueryValues, valueQueryValues);
                            batchBuilder.addValues(queryValues);
                        });
                        batchBuilder.execute();
                    }
                    catch (SQLException e) {
                        SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to save top holder", (Throwable)e);
                    }
                    finally {
                        if (connection != null) {
                            SqlStorageSupplier.this.flushConnection(connection);
                        }
                    }
                };
                if (urgent) {
                    return CompletableFuture.runAsync(runnable);
                }
                runnable.run();
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<Optional<V>> load(K key, boolean urgent) {
                Supplier<Optional> supplier = () -> {
                    Connection connection = null;
                    try {
                        connection = SqlStorageSupplier.this.getConnection();
                        String[] keyColumns = SqlStorageSupplier.this.converter.getKeyColumns();
                        Object[] keyValues = SqlStorageSupplier.this.converter.toKeyQueryValues(key);
                        StringBuilder statement = new StringBuilder("SELECT * FROM `").append(name).append("` WHERE ");
                        for (int i = 0; i < keyColumns.length; ++i) {
                            statement.append("`").append(keyColumns[i]).append("` = ?");
                            if (i == keyColumns.length - 1) continue;
                            statement.append(" AND ");
                        }
                        Optional optional = (Optional)StatementBuilder.create((Connection)connection).setStatement(statement.toString()).addValues(keyValues).query(resultSet -> resultSet.next() ? Optional.of(SqlStorageSupplier.this.converter.getValue(resultSet)) : Optional.empty());
                        return optional;
                    }
                    catch (SQLException e) {
                        SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load top holder", (Throwable)e);
                        Optional optional = Optional.empty();
                        return optional;
                    }
                    finally {
                        if (connection != null) {
                            SqlStorageSupplier.this.flushConnection(connection);
                        }
                    }
                };
                if (urgent) {
                    return CompletableFuture.supplyAsync(supplier);
                }
                return CompletableFuture.completedFuture(supplier.get());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegister() {
                Connection connection = null;
                try {
                    int i;
                    connection = SqlStorageSupplier.this.getConnection();
                    String[] keyColumns = SqlStorageSupplier.this.converter.getKeyColumns();
                    String[] keyColumnDefinitions = SqlStorageSupplier.this.converter.getKeyColumnDefinitions();
                    String[] valueColumnDefinitions = SqlStorageSupplier.this.converter.getValueColumnDefinitions();
                    StringBuilder statement = new StringBuilder("CREATE TABLE IF NOT EXISTS `").append(name).append("` (");
                    for (i = 0; i < keyColumnDefinitions.length + valueColumnDefinitions.length; ++i) {
                        if (i < keyColumnDefinitions.length) {
                            statement.append(keyColumnDefinitions[i]);
                        } else {
                            statement.append(valueColumnDefinitions[i - keyColumnDefinitions.length]);
                        }
                        if (i == keyColumnDefinitions.length + valueColumnDefinitions.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(", PRIMARY KEY (");
                    for (i = 0; i < keyColumns.length; ++i) {
                        statement.append("`").append(keyColumns[i]).append("`");
                        if (i == keyColumns.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(")").append(");");
                    StatementBuilder.create((Connection)connection).setStatement(statement.toString()).update();
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to create table", (Throwable)e);
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }
        };
    }
}

