/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.storage;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.agent.storage.DataStorage;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;

public class StorageAgent<K, V>
implements Agent<K, V>,
Runnable {
    private final Logger logger;
    private final DataHolder<K, V> holder;
    private final DataStorage<K, V> storage;
    private final Queue<Map.Entry<K, V>> queue = new ConcurrentLinkedQueue<Map.Entry<K, V>>();
    private final AtomicReference<Map<K, V>> savingMap = new AtomicReference();
    private final AtomicBoolean saving = new AtomicBoolean(false);
    private int maxEntryPerCall = 10;

    public StorageAgent(Logger logger, DataHolder<K, V> holder, DataStorage<K, V> storage) {
        this.logger = logger;
        this.holder = holder;
        this.storage = storage;
    }

    private void save(boolean urgent) {
        Map.Entry<K, V> entry;
        if (this.saving.get() && !urgent) {
            return;
        }
        this.saving.set(true);
        Map<K, V> map = this.savingMap.get();
        if (map == null) {
            map = new HashMap();
        }
        this.savingMap.set(map);
        for (int i = 0; i < (urgent || this.maxEntryPerCall <= 0 ? Integer.MAX_VALUE : this.maxEntryPerCall) && (entry = this.queue.poll()) != null; ++i) {
            map.put(entry.getKey(), entry.getValue());
        }
        if (map.isEmpty()) {
            this.savingMap.set(null);
            this.saving.set(false);
            return;
        }
        this.storage.save(map, urgent).whenComplete((v, throwable) -> {
            if (throwable != null) {
                this.logger.log(Level.SEVERE, "Failed to save entries for " + this.holder.getName(), (Throwable)throwable);
            } else {
                this.savingMap.set(null);
            }
            this.saving.set(false);
        });
    }

    public void start() {
        this.storage.onRegister();
        try {
            this.storage.load().forEach((uuid, value) -> this.holder.getOrCreateEntry(uuid).setValue(value, false));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load top entries for " + this.holder.getName(), e);
        }
    }

    public void stop() {
        this.storage.onUnregister();
    }

    public void beforeStop() {
        this.save(true);
    }

    public void onUpdate(DataEntry<K, V> entry) {
        this.queue.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(entry.getKey(), entry.getValue()));
    }

    @Override
    public void run() {
        this.save(false);
    }

    public DataStorage<K, V> getStorage() {
        return this.storage;
    }

    public void setMaxEntryPerCall(int taskSaveEntryPerTick) {
        this.maxEntryPerCall = taskSaveEntryPerTick;
    }
}

