/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.storage;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;
import me.hsgamer.topper.storage.core.DataStorage;

public class StorageAgent<K, V>
implements Agent,
DataEntryAgent<K, V>,
Runnable {
    private final Logger logger;
    private final DataHolder<K, V> holder;
    private final DataStorage<K, V> storage;
    private final Queue<Map.Entry<K, V>> queue = new ConcurrentLinkedQueue<Map.Entry<K, V>>();
    private final AtomicReference<Map<K, V>> savingMap = new AtomicReference();
    private final AtomicBoolean saving = new AtomicBoolean(false);
    private int maxEntryPerCall = 10;

    public StorageAgent(Logger logger, DataHolder<K, V> holder, DataStorage<K, V> storage) {
        this.logger = logger;
        this.holder = holder;
        this.storage = storage;
    }

    private void save(boolean urgent) {
        Map.Entry<K, V> entry2;
        if (this.saving.get() && !urgent) {
            return;
        }
        this.saving.set(true);
        Map<K, V> map = this.savingMap.get();
        if (map == null) {
            map = new HashMap();
        }
        this.savingMap.set(map);
        for (int i = 0; i < (urgent || this.maxEntryPerCall <= 0 ? Integer.MAX_VALUE : this.maxEntryPerCall) && (entry2 = this.queue.poll()) != null; ++i) {
            map.put(entry2.getKey(), entry2.getValue());
        }
        if (map.isEmpty()) {
            this.savingMap.set(null);
            this.saving.set(false);
            return;
        }
        HashSet removeKeys = new HashSet();
        Map<Object, Object> finalMap = map.entrySet().stream().filter(entry -> {
            if (entry.getValue() == null) {
                removeKeys.add(entry.getKey());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Runnable saveTask = () -> {
            try {
                this.storage.save(finalMap);
                if (!removeKeys.isEmpty()) {
                    this.storage.remove((Collection)removeKeys);
                }
                this.savingMap.set(null);
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "Failed to save entries for " + this.holder.getName(), t);
            }
            finally {
                this.saving.set(false);
            }
        };
        if (urgent) {
            saveTask.run();
        } else {
            CompletableFuture.runAsync(saveTask);
        }
    }

    public void start() {
        this.storage.onRegister();
        try {
            this.storage.load().forEach((uuid, value) -> this.holder.getOrCreateEntry(uuid).setValue(value, false));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load top entries for " + this.holder.getName(), e);
        }
    }

    public void stop() {
        this.storage.onUnregister();
    }

    public void beforeStop() {
        this.save(true);
    }

    public void onUpdate(DataEntry<K, V> entry, V oldValue) {
        this.queue.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(entry.getKey(), entry.getValue()));
    }

    public void onRemove(DataEntry<K, V> entry) {
        this.queue.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(entry.getKey(), null));
    }

    @Override
    public void run() {
        this.save(false);
    }

    public DataStorage<K, V> getStorage() {
        return this.storage;
    }

    public void setMaxEntryPerCall(int taskSaveEntryPerTick) {
        this.maxEntryPerCall = taskSaveEntryPerTick;
    }
}

