/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.update;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.hsgamer.topper.agent.core.Agent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;

public class UpdateAgent<K, V>
implements Agent<K, V>,
Runnable {
    private final Logger logger;
    private final Queue<K> updateQueue = new ConcurrentLinkedQueue<K>();
    private final DataHolder<K, V> holder;
    private final Function<K, CompletableFuture<Optional<V>>> updateFunction;
    private int maxEntryPerCall = 10;

    public UpdateAgent(Logger logger, DataHolder<K, V> holder, Function<K, CompletableFuture<Optional<V>>> updateFunction) {
        this.logger = logger;
        this.holder = holder;
        this.updateFunction = updateFunction;
    }

    public void setMaxEntryPerCall(int maxEntryPerCall) {
        this.maxEntryPerCall = maxEntryPerCall;
    }

    @Override
    public void run() {
        K k;
        for (int i = 0; i < this.maxEntryPerCall && (k = this.updateQueue.poll()) != null; ++i) {
            DataEntry entry = this.holder.getOrCreateEntry(k);
            this.updateFunction.apply(k).whenComplete((optional, throwable) -> {
                if (throwable != null) {
                    this.logger.log(Level.WARNING, "An error occurred while updating the entry: " + k, (Throwable)throwable);
                } else {
                    optional.ifPresent(arg_0 -> ((DataEntry)entry).setValue(arg_0));
                }
                this.updateQueue.add(k);
            });
        }
    }

    public void onCreate(DataEntry<K, V> entry) {
        this.updateQueue.add(entry.getKey());
    }

    public void onRemove(DataEntry<K, V> entry) {
        this.updateQueue.remove(entry.getKey());
    }
}

