/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;

public class UpdateAgent<K, V>
implements DataEntryAgent<K, V>,
Runnable {
    private static final Logger LOGGER = LoggerProvider.getLogger(UpdateAgent.class);
    private final Queue<K> updateQueue = new ConcurrentLinkedQueue<K>();
    private final DataHolder<K, V> holder;
    private final Function<K, CompletableFuture<Optional<V>>> updateFunction;
    private final List<Predicate<K>> filters = new ArrayList<Predicate<K>>();
    private int maxEntryPerCall = 10;

    public UpdateAgent(DataHolder<K, V> holder, Function<K, CompletableFuture<Optional<V>>> updateFunction) {
        this.holder = holder;
        this.updateFunction = updateFunction;
    }

    public void setMaxEntryPerCall(int maxEntryPerCall) {
        this.maxEntryPerCall = maxEntryPerCall;
    }

    public void addFilter(Predicate<K> filter) {
        this.filters.add(filter);
    }

    private boolean canUpdate(K key) {
        return this.filters.stream().allMatch(predicate -> predicate.test(key));
    }

    @Override
    public void run() {
        K k;
        for (int i = 0; i < this.maxEntryPerCall && (k = this.updateQueue.poll()) != null; ++i) {
            DataEntry entry = this.holder.getOrCreateEntry(k);
            ((CompletableFuture)(this.canUpdate(k) ? this.updateFunction.apply(k).thenAcceptAsync(optional -> optional.ifPresent(arg_0 -> ((DataEntry)entry).setValue(arg_0))) : CompletableFuture.completedFuture(null))).whenComplete((v, throwable) -> {
                if (throwable != null) {
                    LOGGER.log(LogLevel.ERROR, "An error occurred while updating the entry: " + k, throwable);
                }
                this.updateQueue.add(k);
            });
        }
    }

    public void onCreate(DataEntry<K, V> entry) {
        this.updateQueue.add(entry.getKey());
    }

    public void onRemove(DataEntry<K, V> entry) {
        this.updateQueue.remove(entry.getKey());
    }
}

