/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.agent.update;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import me.hsgamer.topper.agent.core.DataEntryAgent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;

public class UpdateAgent<K, V>
implements DataEntryAgent<K, V> {
    private final Queue<K> updateQueue = new ConcurrentLinkedQueue<K>();
    private final Queue<Map.Entry<K, V>> setQueue = new ConcurrentLinkedQueue<Map.Entry<K, V>>();
    private final DataHolder<K, V> holder;
    private final Function<K, Optional<V>> updateFunction;
    private final List<Predicate<K>> filters = new ArrayList<Predicate<K>>();

    public UpdateAgent(DataHolder<K, V> holder, Function<K, Optional<V>> updateFunction) {
        this.holder = holder;
        this.updateFunction = updateFunction;
    }

    public void addFilter(Predicate<K> filter) {
        this.filters.add(filter);
    }

    private boolean canUpdate(K key) {
        return this.filters.stream().allMatch(predicate -> predicate.test(key));
    }

    public Runnable getUpdateRunnable(int maxEntryPerCall) {
        return () -> {
            K k;
            for (int i = 0; i < maxEntryPerCall && (k = this.updateQueue.poll()) != null; ++i) {
                if (!this.canUpdate(k)) {
                    this.updateQueue.add(k);
                    continue;
                }
                Optional<V> value = this.updateFunction.apply(k);
                if (!value.isPresent()) {
                    this.updateQueue.add(k);
                    continue;
                }
                this.setQueue.add(new AbstractMap.SimpleImmutableEntry<K, V>(k, value.get()));
            }
        };
    }

    public Runnable getSetRunnable() {
        return () -> {
            Map.Entry<K, V> entry;
            while ((entry = this.setQueue.poll()) != null) {
                Optional optionalDataEntry = this.holder.getEntry(entry.getKey());
                if (!optionalDataEntry.isPresent()) continue;
                DataEntry dataEntry = (DataEntry)optionalDataEntry.get();
                dataEntry.setValue(entry.getValue());
                this.updateQueue.add(entry.getKey());
            }
        };
    }

    public void onCreate(DataEntry<K, V> entry) {
        this.updateQueue.add(entry.getKey());
    }

    public void onRemove(DataEntry<K, V> entry) {
        this.updateQueue.remove(entry.getKey());
    }
}

