/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.core;

import java.util.Objects;
import java.util.function.UnaryOperator;
import me.hsgamer.topper.core.DataHolder;

public final class DataEntry<K, V> {
    private final K key;
    private final DataHolder<K, V> holder;
    private volatile V value;

    public DataEntry(K key, DataHolder<K, V> holder) {
        this.key = key;
        this.holder = holder;
        this.value = holder.getDefaultValue();
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.setValue(value, true);
    }

    public void setValue(UnaryOperator<V> operator) {
        this.setValue(operator, true);
    }

    public void setValue(V value, boolean notify) {
        if (Objects.equals(this.value, value)) {
            return;
        }
        V oldValue = this.value;
        this.value = value;
        if (notify) {
            this.holder.onUpdate(this, oldValue);
        }
    }

    public void setValue(UnaryOperator<V> operator, boolean notify) {
        this.setValue(operator.apply(this.value), notify);
    }

    public DataHolder<K, V> getHolder() {
        return this.holder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataEntry dataEntry = (DataEntry)o;
        return Objects.equals(this.getKey(), dataEntry.getKey()) && Objects.equals(this.getHolder(), dataEntry.getHolder()) && Objects.equals(this.getValue(), dataEntry.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getHolder(), this.getValue());
    }
}

