/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.core;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import me.hsgamer.topper.core.DataHolder;

public final class DataEntry<K, V> {
    private final K key;
    private final DataHolder<K, V> holder;
    private final AtomicReference<V> value;

    public DataEntry(K key, DataHolder<K, V> holder) {
        this.key = key;
        this.holder = holder;
        this.value = new AtomicReference<V>(holder.getDefaultValue());
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value.get();
    }

    public void setValue(V value) {
        this.setValue(value, true);
    }

    public void setValue(UnaryOperator<V> operator) {
        this.setValue(operator, true);
    }

    public void setValue(V value, boolean notify) {
        this.setValue(v -> value, notify);
    }

    public void setValue(UnaryOperator<V> operator, boolean notify) {
        this.value.updateAndGet(oldValue -> {
            Object newValue = operator.apply(oldValue);
            if (notify && !Objects.equals(oldValue, newValue)) {
                this.holder.onUpdate(this, oldValue, newValue);
            }
            return newValue;
        });
    }

    public DataHolder<K, V> getHolder() {
        return this.holder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataEntry dataEntry = (DataEntry)o;
        return Objects.equals(this.getKey(), dataEntry.getKey()) && Objects.equals(this.getHolder(), dataEntry.getHolder()) && Objects.equals(this.getValue(), dataEntry.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getHolder(), this.getValue());
    }
}

