/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.core;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.topper.core.DataEntry;

public class DataHolder<K, V> {
    private final Map<K, DataEntry<K, V>> entryMap = new ConcurrentHashMap<K, DataEntry<K, V>>();
    private final String name;

    protected DataHolder(String name) {
        this.name = name;
    }

    public V getDefaultValue() {
        return null;
    }

    protected void onCreate(DataEntry<K, V> entry) {
    }

    protected void onRemove(DataEntry<K, V> entry) {
    }

    protected void onUpdate(DataEntry<K, V> entry, V oldValue, V newValue) {
    }

    public final String getName() {
        return this.name;
    }

    public final Map<K, DataEntry<K, V>> getEntryMap() {
        return Collections.unmodifiableMap(this.entryMap);
    }

    public final Optional<DataEntry<K, V>> getEntry(K key) {
        return Optional.ofNullable(this.entryMap.get(key));
    }

    public final DataEntry<K, V> getOrCreateEntry(K key) {
        return this.entryMap.computeIfAbsent(key, u -> {
            DataEntry entry = new DataEntry(u, this);
            this.onCreate(entry);
            return entry;
        });
    }

    public final void removeEntry(K key) {
        Optional.ofNullable(this.entryMap.remove(key)).ifPresent(this::onRemove);
    }

    public final void clear() {
        this.entryMap.clear();
    }
}

