/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.data.simple;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.topper.data.core.DataEntry;
import me.hsgamer.topper.data.core.DataHolder;
import me.hsgamer.topper.data.simple.SimpleDataEntry;
import org.jetbrains.annotations.Nullable;

public class SimpleDataHolder<K, V>
implements DataHolder<K, V> {
    private final Map<K, DataEntry<K, V>> entryMap = new ConcurrentHashMap<K, DataEntry<K, V>>();

    @Nullable
    public V getDefaultValue() {
        return null;
    }

    public DataEntry<K, V> getOrCreateEntry(K key) {
        return this.entryMap.computeIfAbsent(key, u -> {
            SimpleDataEntry entry = new SimpleDataEntry(u, this);
            this.onCreate(entry);
            return entry;
        });
    }

    public Optional<DataEntry<K, V>> getEntry(K key) {
        return Optional.ofNullable(this.entryMap.get(key));
    }

    public void removeEntry(K key) {
        Optional.ofNullable(this.entryMap.remove(key)).ifPresent(arg_0 -> ((SimpleDataHolder)this).onRemove(arg_0));
    }

    public Map<K, DataEntry<K, V>> getEntryMap() {
        return Collections.unmodifiableMap(this.entryMap);
    }

    public void clear() {
        this.entryMap.values().forEach(arg_0 -> ((SimpleDataHolder)this).onRemove(arg_0));
        this.entryMap.clear();
    }
}

