/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.data.simple;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import me.hsgamer.topper.data.core.DataEntry;
import me.hsgamer.topper.data.core.DataHolder;
import me.hsgamer.topper.data.simple.SimpleDataHolder;

public class SimpleDataEntry<K, V>
implements DataEntry<K, V> {
    private final K key;
    private final SimpleDataHolder<K, V> holder;
    private final AtomicReference<V> value;

    public SimpleDataEntry(K key, SimpleDataHolder<K, V> holder) {
        this.key = key;
        this.holder = holder;
        this.value = new AtomicReference<V>(holder.getDefaultValue());
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value.get();
    }

    public void setValue(UnaryOperator<V> operator, boolean notify) {
        this.value.updateAndGet(oldValue -> {
            Object newValue = operator.apply(oldValue);
            if (newValue == null) {
                newValue = this.holder.getDefaultValue();
            }
            if (notify && !Objects.equals(oldValue, newValue)) {
                this.holder.onUpdate(this, oldValue, newValue);
            }
            return newValue;
        });
    }

    public DataHolder<K, V> getHolder() {
        return this.holder;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDataEntry that = (SimpleDataEntry)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getHolder(), that.getHolder()) && Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getHolder(), this.getValue());
    }
}

