/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.query.holder;

import java.util.Optional;
import me.hsgamer.topper.data.core.DataEntry;
import me.hsgamer.topper.data.core.DataHolder;
import me.hsgamer.topper.query.simple.SimpleQuery;
import me.hsgamer.topper.query.simple.SimpleQueryContext;
import me.hsgamer.topper.query.simple.SimpleQueryDisplay;
import org.jetbrains.annotations.NotNull;

public abstract class HolderQuery<K, V, H extends DataHolder<K, V>, A>
extends SimpleQuery<A, Context<K, V, H>> {
    protected HolderQuery() {
        this.registerActorAction("key", (actor, context) -> {
            Object key = this.getKey((A)actor, (Context<K, V, H>)context).orElse(null);
            return this.getDisplay(context.holder).getDisplayKey(key);
        });
        this.registerActorAction("name", (actor, context) -> {
            Object key = this.getKey((A)actor, (Context<K, V, H>)context).orElse(null);
            return this.getDisplay(context.holder).getDisplayName(key);
        });
        this.registerActorAction("value", (actor, context) -> {
            Object value = this.getKey((A)actor, (Context<K, V, H>)context).flatMap(arg_0 -> context.holder.getEntry(arg_0)).map(DataEntry::getValue).orElse(null);
            return this.getDisplay(context.holder).getDisplayValue(value, context.parent.args);
        });
        this.registerActorAction("value_raw", (actor, context) -> {
            Object value = this.getKey((A)actor, (Context<K, V, H>)context).flatMap(arg_0 -> context.holder.getEntry(arg_0)).map(DataEntry::getValue).orElse(null);
            return this.getDisplay(context.holder).getDisplayValue(value, "raw");
        });
    }

    protected abstract Optional<H> getHolder(@NotNull String var1);

    @NotNull
    protected abstract SimpleQueryDisplay<K, V> getDisplay(@NotNull H var1);

    protected boolean isSingleHolder() {
        return false;
    }

    protected abstract Optional<K> getKey(@NotNull A var1, @NotNull Context<K, V, H> var2);

    protected Optional<Context<K, V, H>> getContext(@NotNull String query) {
        return SimpleQueryContext.fromQuery((String)query, (boolean)this.isSingleHolder()).map(context -> {
            Optional<H> optionalHolder = this.getHolder(context.name);
            if (!optionalHolder.isPresent()) {
                return null;
            }
            DataHolder holder = (DataHolder)optionalHolder.get();
            return new Context(holder, (SimpleQueryContext)context);
        });
    }

    public static final class Context<K, V, H extends DataHolder<K, V>>
    implements SimpleQuery.Context {
        @NotNull
        public final H holder;
        @NotNull
        public final SimpleQueryContext parent;

        Context(@NotNull H holder, @NotNull SimpleQueryContext parent) {
            this.holder = holder;
            this.parent = parent;
        }

        @NotNull
        public String getActionName() {
            return this.parent.getActionName();
        }
    }
}

