/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.query.snapshot;

import me.hsgamer.topper.agent.snapshot.SnapshotAgent;
import me.hsgamer.topper.core.DataEntry;
import me.hsgamer.topper.core.DataHolder;
import me.hsgamer.topper.query.core.QueryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SnapshotQueryManager<K, V, H extends DataHolder<K, V>, A>
extends QueryManager<K, V, H, A> {
    protected SnapshotQueryManager() {
        this.registerFunction("top_name", (holder, args) -> {
            int i = 1;
            try {
                i = Integer.parseInt(args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            K key = this.getSnapshotAgent(holder).getEntryByIndex(i - 1).map(DataEntry::getKey).orElse(null);
            return this.getDisplayName(key, holder);
        });
        this.registerFunction("top_key", (holder, args) -> {
            int i = 1;
            try {
                i = Integer.parseInt(args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            K key = this.getSnapshotAgent(holder).getEntryByIndex(i - 1).map(DataEntry::getKey).orElse(null);
            return this.getDisplayKey(key, holder);
        });
        this.registerFunction("top_value", (holder, args) -> {
            String[] split = args.split(";", 2);
            int i = 1;
            try {
                i = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String valueArgs = split.length > 1 ? split[1] : "";
            V value = this.getSnapshotAgent(holder).getEntryByIndex(i - 1).map(DataEntry::getValue).orElse(null);
            return this.getDisplayValue(value, holder, valueArgs);
        });
        this.registerFunction("top_value_raw", (holder, args) -> {
            int i = 1;
            try {
                i = Integer.parseInt(args);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            V value = this.getSnapshotAgent(holder).getEntryByIndex(i - 1).map(DataEntry::getValue).orElse(null);
            return this.getDisplayValue(value, holder, "raw");
        });
        this.registerActorFunction("top_rank", (actor, holder) -> {
            int index = this.getSnapshotAgent(holder).getSnapshotIndex(this.getKeyFromActor(actor));
            return Integer.toString(index + 1);
        });
        this.registerAction("value", (actor, holder, args) -> {
            if (actor == null) {
                return null;
            }
            V value = holder.getEntry(this.getKeyFromActor(actor)).map(DataEntry::getValue).orElse(null);
            return this.getDisplayValue(value, holder, args);
        });
        this.registerActorFunction("value_raw", (actor, holder) -> {
            V value = holder.getEntry(this.getKeyFromActor(actor)).map(DataEntry::getValue).orElse(null);
            return this.getDisplayValue(value, holder, "raw");
        });
    }

    @NotNull
    protected abstract SnapshotAgent<K, V> getSnapshotAgent(@NotNull H var1);

    @NotNull
    protected abstract String getDisplayName(@Nullable K var1, @NotNull H var2);

    @NotNull
    protected abstract String getDisplayValue(@Nullable V var1, @NotNull H var2, @NotNull String var3);

    @NotNull
    protected abstract String getDisplayKey(@Nullable K var1, @NotNull H var2);

    @NotNull
    protected abstract K getKeyFromActor(@NotNull A var1);
}

