/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.spigot.value.placeholderapi;

import me.clip.placeholderapi.PlaceholderAPI;
import me.hsgamer.topper.value.core.ValueProvider;
import me.hsgamer.topper.value.core.ValueWrapper;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlaceholderValueProvider
implements ValueProvider<OfflinePlayer, String> {
    private final String placeholder;
    private final boolean isOnlineOnly;

    public PlaceholderValueProvider(String placeholder, boolean isOnlineOnly) {
        this.placeholder = placeholder;
        this.isOnlineOnly = isOnlineOnly;
    }

    @NotNull
    public ValueWrapper<String> apply(@NotNull OfflinePlayer player) {
        if (this.isOnlineOnly && !player.isOnline()) {
            return ValueWrapper.notHandled();
        }
        try {
            String replaced = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.placeholder);
            if (this.placeholder.equals(replaced)) {
                return ValueWrapper.notHandled();
            }
        }
        catch (Exception e) {
            return ValueWrapper.error((String)("Error while parsing the placeholder: " + this.placeholder), (Throwable)e);
        }
        return ValueWrapper.handled((Object)this.placeholder);
    }
}

