/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.bundle;

import java.util.function.Function;
import me.hsgamer.hscore.builder.Builder;
import me.hsgamer.topper.storage.bundle.DataStorageSetting;
import me.hsgamer.topper.storage.bundle.DataStorageSupplier;
import me.hsgamer.topper.storage.bundle.ValueConverter;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.flat.properties.PropertiesDataStorage;
import me.hsgamer.topper.storage.sql.mysql.MySqlDataStorageSupplier;
import me.hsgamer.topper.storage.sql.sqlite.NewSqliteDataStorageSupplier;
import me.hsgamer.topper.storage.sql.sqlite.SqliteDataStorageSupplier;

public class DataStorageBuilder
extends Builder<DataStorageSetting, DataStorageSupplier> {
    private final Function<DataStorageSetting, DataStorageSupplier> defaultSupplier = setting -> new DataStorageSupplier(){
        final /* synthetic */ DataStorageSetting val$setting;
        {
            this.val$setting = dataStorageSetting;
        }

        @Override
        public <K, V> DataStorage<K, V> getStorage(String name, ValueConverter<K, V> valueConverter) {
            return new PropertiesDataStorage(this.val$setting.getBaseFolder(), name, valueConverter.getKeyFlatValueConverter(), valueConverter.getValueFlatValueConverter());
        }
    };

    public DataStorageBuilder() {
        this.register(this.defaultSupplier, new String[]{"flat", "properties", ""});
        this.register(setting -> {
            final String type = "SQLite";
            final SqliteDataStorageSupplier supplier = new SqliteDataStorageSupplier(setting.getBaseFolder(), setting.getDatabaseSetting(), setting.getSqlClientFunction());
            return new DataStorageSupplier(){

                @Override
                public <K, V> DataStorage<K, V> getStorage(String name, ValueConverter<K, V> valueConverter) {
                    return supplier.getStorage(name, valueConverter.getKeySqlValueConverter(type), valueConverter.getValueSqlValueConverter(type));
                }
            };
        }, new String[]{"sqlite", "sqlite3"});
        this.register(setting -> {
            String type = "SQLite";
            NewSqliteDataStorageSupplier supplier = new NewSqliteDataStorageSupplier(setting.getBaseFolder(), setting.getDatabaseSetting(), setting.getSqlClientFunction());
            return new DataStorageSupplier(){
                final /* synthetic */ SqliteDataStorageSupplier val$supplier;
                final /* synthetic */ String val$type;
                {
                    this.val$supplier = sqliteDataStorageSupplier;
                    this.val$type = string;
                }

                @Override
                public <K, V> DataStorage<K, V> getStorage(String name, ValueConverter<K, V> valueConverter) {
                    return this.val$supplier.getStorage(name, valueConverter.getKeySqlValueConverter(this.val$type), valueConverter.getValueSqlValueConverter(this.val$type));
                }
            };
        }, new String[]{"new-sqlite", "new-sqlite3"});
        this.register(setting -> {
            final String type = "MySQL";
            final MySqlDataStorageSupplier supplier = new MySqlDataStorageSupplier(setting.getDatabaseSetting(), setting.getSqlClientFunction());
            return new DataStorageSupplier(){

                @Override
                public <K, V> DataStorage<K, V> getStorage(String name, ValueConverter<K, V> valueConverter) {
                    return supplier.getStorage(name, valueConverter.getKeySqlValueConverter(type), valueConverter.getValueSqlValueConverter(type));
                }
            };
        }, new String[]{"mysql", "mysql-connector-java", "mysql-connector"});
    }

    public DataStorageSupplier buildSupplier(String type, DataStorageSetting setting) {
        return this.build(type, setting).orElseGet(() -> this.defaultSupplier.apply(setting));
    }
}

