/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.hsgamer.topper.storage.simple.converter.ValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComplexValueConverter<T>
implements ValueConverter<T> {
    private final String stringSeparator;
    private final List<Entry<T>> entries;
    private final Supplier<T> constructor;
    private final String[] sqlColumns;
    private final String[] sqlColumnDefinitions;

    private ComplexValueConverter(String stringSeparator, List<Entry<T>> entries, Supplier<T> constructor) {
        this.stringSeparator = stringSeparator;
        this.entries = Collections.unmodifiableList(entries);
        this.constructor = constructor;
        ArrayList<String> sqlColumns = new ArrayList<String>();
        ArrayList<String> sqlColumnDefinitions = new ArrayList<String>();
        for (Entry<T> entry : entries) {
            String[] columns = ((Entry)entry).converter.getSqlColumns();
            String[] columnDefinitions = ((Entry)entry).converter.getSqlColumnDefinitions();
            sqlColumns.addAll(Arrays.asList(columns));
            sqlColumnDefinitions.addAll(Arrays.asList(columnDefinitions));
        }
        this.sqlColumns = sqlColumns.toArray(new String[0]);
        this.sqlColumnDefinitions = sqlColumnDefinitions.toArray(new String[0]);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @NotNull
    public String toRawString(@NotNull T value) {
        StringJoiner joiner = new StringJoiner(this.stringSeparator);
        for (Entry<T> entry : this.entries) {
            String rawString = ((Entry)entry).converter.toRawString(((Entry)entry).getter.apply(value));
            joiner.add(rawString);
        }
        return joiner.toString();
    }

    @Nullable
    public T fromRawString(@NotNull String value) {
        String[] values = value.split(Pattern.quote(this.stringSeparator), -1);
        if (values.length != this.entries.size()) {
            return null;
        }
        Object instance = this.constructor.get();
        for (int i = 0; i < values.length; ++i) {
            Entry<T> entry = this.entries.get(i);
            Object objectValue = ((Entry)entry).converter.fromRawString(values[i]);
            if (objectValue == null) {
                return null;
            }
            instance = ((Entry)entry).setter.apply(instance, objectValue);
        }
        return instance;
    }

    @NotNull
    public Map<String, Object> toObjectMap(@NotNull T value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Entry<T> entry : this.entries) {
            map.putAll(((Entry)entry).converter.toObjectMap(((Entry)entry).getter.apply(value)));
        }
        return map;
    }

    @Nullable
    public T fromObjectMap(@NotNull Map<String, Object> map) {
        Object instance = this.constructor.get();
        for (Entry<T> entry : this.entries) {
            Object objectValue = ((Entry)entry).converter.fromObjectMap(map);
            if (objectValue == null) {
                return null;
            }
            instance = ((Entry)entry).setter.apply(instance, objectValue);
        }
        return instance;
    }

    public String[] getSqlColumns() {
        return this.sqlColumns;
    }

    public String[] getSqlColumnDefinitions() {
        return this.sqlColumnDefinitions;
    }

    public Object[] toSqlValues(@NotNull T value) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Entry<T> entry : this.entries) {
            Object[] objectValues = ((Entry)entry).converter.toSqlValues(((Entry)entry).getter.apply(value));
            values.addAll(Arrays.asList(objectValues));
        }
        return values.toArray(new Object[0]);
    }

    @Nullable
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        Object instance = this.constructor.get();
        for (Entry<T> entry : this.entries) {
            Object objectValue = ((Entry)entry).converter.fromSqlResultSet(resultSet);
            if (objectValue == null) {
                return null;
            }
            instance = ((Entry)entry).setter.apply(instance, objectValue);
        }
        return instance;
    }

    public static class Builder<T> {
        private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
        private String stringSeparator = "||";
        private Supplier<T> constructor;

        private Builder() {
        }

        public Builder<T> stringSeparator(String rawStringSeparator) {
            this.stringSeparator = rawStringSeparator;
            return this;
        }

        public Builder<T> constructor(Supplier<T> constructor) {
            this.constructor = constructor;
            return this;
        }

        public <V> Builder<T> entry(ValueConverter<V> converter, Function<T, V> getter, BiFunction<T, V, T> setter) {
            ValueConverter<V> objectConverter = converter;
            Function<T, V> objectGetter = getter;
            BiFunction<T, V, T> objectSetter = setter;
            Entry entry = new Entry(objectConverter, objectGetter, objectSetter);
            this.entries.add(entry);
            return this;
        }

        public ComplexValueConverter<T> build() {
            if (this.constructor == null) {
                throw new IllegalStateException("Constructor is not set");
            }
            if (this.entries.isEmpty()) {
                throw new IllegalStateException("Entries are empty");
            }
            return new ComplexValueConverter(this.stringSeparator, this.entries, this.constructor);
        }
    }

    private static class Entry<T> {
        private final ValueConverter<Object> converter;
        private final Function<T, Object> getter;
        private final BiFunction<T, Object, T> setter;

        private Entry(ValueConverter<Object> converter, Function<T, Object> getter, BiFunction<T, Object, T> setter) {
            this.converter = converter;
            this.getter = getter;
            this.setter = setter;
        }
    }
}

