/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import me.hsgamer.topper.storage.simple.converter.ValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleValueConverter<T>
implements ValueConverter<T> {
    private final Function<@NotNull T, @NotNull String> toStringConverter;
    private final Function<@NotNull String, @Nullable T> fromStringConverter;
    private final String valueName;
    private final String sqlType;
    private final boolean isStringNationalized;

    public SimpleValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, String sqlType, boolean isStringNationalized) {
        this.toStringConverter = toStringConverter;
        this.fromStringConverter = fromStringConverter;
        this.valueName = valueName;
        this.sqlType = sqlType;
        this.isStringNationalized = isStringNationalized;
    }

    public SimpleValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, String sqlType) {
        this(toStringConverter, fromStringConverter, valueName, sqlType, sqlType.toUpperCase(Locale.ROOT).startsWith("N"));
    }

    public SimpleValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, boolean isStringNationalized, int stringMaxLength) {
        this(toStringConverter, fromStringConverter, valueName, (isStringNationalized ? "N" : "") + "VARCHAR(" + stringMaxLength + ")", isStringNationalized);
    }

    @NotNull
    public String toRawString(@NotNull T value) {
        return this.toStringConverter.apply(value);
    }

    @Nullable
    public T fromRawString(@NotNull String value) {
        return this.fromStringConverter.apply(value);
    }

    @NotNull
    public Map<String, Object> toObjectMap(@NotNull T value) {
        return Collections.singletonMap(this.valueName, value);
    }

    @Nullable
    public T fromObjectMap(@NotNull Map<String, Object> map) {
        Object value = map.get(this.valueName);
        return value == null ? null : (T)this.fromRawString(value.toString());
    }

    public String[] getSqlColumns() {
        return new String[]{this.valueName};
    }

    public String[] getSqlColumnDefinitions() {
        return new String[]{this.sqlType + " NOT NULL"};
    }

    public Object[] toSqlValues(@NotNull T value) {
        return new Object[]{this.toRawString(value)};
    }

    @Nullable
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        String value = this.isStringNationalized ? resultSet.getNString(this.valueName) : resultSet.getString(this.valueName);
        return value == null ? null : (T)this.fromRawString(value);
    }
}

