/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.flat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.simple.converter.ValueConverter;
import me.hsgamer.topper.storage.simple.supplier.DataStorageSupplier;

public class FlatStorageSupplier
implements DataStorageSupplier {
    private final Logger logger = LoggerProvider.getLogger(this.getClass());
    private final File baseFolder;

    public FlatStorageSupplier(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public <K, V> DataStorage<K, V> getStorage(String name, final ValueConverter<K> keyConverter, final ValueConverter<V> valueConverter) {
        final Properties properties = new Properties();
        File file = new File(this.baseFolder, name + ".properties");
        final Runnable loadRunnable = () -> {
            try {
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileInputStream fileOutputStream = new FileInputStream(file);){
                    properties.load(fileOutputStream);
                }
            }
            catch (IOException e) {
                this.logger.log(LogLevel.ERROR, "Failed to load the data", (Throwable)e);
            }
        };
        final Runnable saveRunnable = () -> {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                properties.store(fileOutputStream, null);
            }
            catch (IOException e) {
                this.logger.log(LogLevel.ERROR, "Failed to save the data", (Throwable)e);
            }
        };
        return new DataStorage<K, V>(){

            public Map<K, V> load() {
                HashMap map = new HashMap();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    Object k = keyConverter.fromRawString(key.toString());
                    Object v = valueConverter.fromRawString(value.toString());
                    if (k != null && v != null) {
                        map.put(k, v);
                    }
                }));
                return map;
            }

            public Optional<V> load(K key) {
                return Optional.ofNullable(properties.getProperty(keyConverter.toRawString(key))).map(arg_0 -> ((ValueConverter)valueConverter).fromRawString(arg_0));
            }

            public Optional<DataStorage.Modifier<K, V>> modify() {
                return Optional.of(new DataStorage.Modifier<K, V>(){
                    private final Map<K, V> map = new HashMap();
                    private final Set<K> removeSet = new HashSet();

                    public void save(Map<K, V> map) {
                        this.map.putAll(map);
                        this.removeSet.removeIf(this.map::containsKey);
                    }

                    public void remove(Collection<K> keys) {
                        this.removeSet.addAll(keys);
                        this.removeSet.forEach(this.map::remove);
                    }

                    public void commit() {
                        this.map.forEach((k, v) -> properties.put(keyConverter.toRawString(k), valueConverter.toRawString(v)));
                        this.removeSet.forEach(key -> properties.remove(keyConverter.toRawString(key)));
                        saveRunnable.run();
                    }

                    public void rollback() {
                        this.map.clear();
                        this.removeSet.clear();
                    }
                });
            }

            public void onRegister() {
                loadRunnable.run();
            }

            public void onUnregister() {
                saveRunnable.run();
            }
        };
    }
}

