/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.supplier;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.simple.converter.FlatEntryConverter;
import me.hsgamer.topper.storage.simple.setting.DataStorageSetting;
import me.hsgamer.topper.storage.simple.supplier.DataStorageSupplier;

public class FlatStorageSupplier
implements DataStorageSupplier {
    private final Logger logger = LoggerProvider.getLogger(this.getClass());
    private final File baseFolder;

    public FlatStorageSupplier(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    @Override
    public <K, V> DataStorage<K, V> getStorage(String name, DataStorageSetting<K, V> setting) {
        final FlatEntryConverter<K, V> converter = setting.getFlatEntryConverter();
        final Properties properties = new Properties();
        File file = new File(this.baseFolder, name + ".properties");
        final Runnable loadRunnable = () -> {
            try {
                if (!file.exists()) {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileInputStream fileOutputStream = new FileInputStream(file);){
                    properties.load(fileOutputStream);
                }
            }
            catch (IOException e) {
                this.logger.log(LogLevel.ERROR, "Failed to load the data", (Throwable)e);
            }
        };
        final Runnable saveRunnable = () -> {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                properties.store(fileOutputStream, "Data for " + name);
            }
            catch (IOException e) {
                this.logger.log(LogLevel.ERROR, "Failed to save the data", (Throwable)e);
            }
        };
        return new DataStorage<K, V>(){

            public Map<K, V> load() {
                HashMap map = new HashMap();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                    Object k = converter.toKey(key.toString());
                    Object v = converter.toValue(value.toString());
                    if (k != null && v != null) {
                        map.put(k, v);
                    }
                }));
                return map;
            }

            public void save(Map<K, V> map) {
                map.forEach((k, v) -> properties.put(converter.toRawKey(k), converter.toRawValue(v)));
                saveRunnable.run();
            }

            public Optional<V> load(K key) {
                return Optional.ofNullable(properties.getProperty(converter.toRawKey(key))).map(converter::toValue);
            }

            public void remove(Collection<K> keys) {
                keys.forEach(key -> properties.remove(converter.toRawKey(key)));
                saveRunnable.run();
            }

            public void onRegister() {
                loadRunnable.run();
            }

            public void onUnregister() {
                saveRunnable.run();
            }
        };
    }
}

