/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.supplier;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.hsgamer.hscore.database.client.sql.BatchBuilder;
import me.hsgamer.hscore.database.client.sql.StatementBuilder;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.simple.converter.SqlEntryConverter;
import me.hsgamer.topper.storage.simple.setting.DataStorageSetting;
import me.hsgamer.topper.storage.simple.supplier.DataStorageSupplier;

public abstract class SqlStorageSupplier
implements DataStorageSupplier {
    protected final Logger logger = LoggerProvider.getLogger(this.getClass());

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void flushConnection(Connection var1);

    protected abstract List<String> toSaveStatement(String var1, String[] var2, String[] var3);

    protected abstract List<Object[]> toSaveValues(Object[] var1, Object[] var2);

    @Override
    public <K, V> DataStorage<K, V> getStorage(final String name, DataStorageSetting<K, V> setting) {
        final SqlEntryConverter<K, V> converter = setting.getSqlEntryConverter();
        return new DataStorage<K, V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<K, V> load() {
                Connection connection = null;
                try {
                    connection = SqlStorageSupplier.this.getConnection();
                    Map<Object, Object> map = StatementBuilder.create((Connection)connection).setStatement("SELECT * FROM `" + name + "`;").queryList(resultSet -> new AbstractMap.SimpleEntry(converter.getKey(resultSet), converter.getValue(resultSet))).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    return map;
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load top holder", (Throwable)e);
                    Map map = Collections.emptyMap();
                    return map;
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void save(Map<K, V> map) {
                Connection connection = null;
                try {
                    connection = SqlStorageSupplier.this.getConnection();
                    String[] keyColumns = converter.getKeyColumns();
                    String[] valueColumns = converter.getValueColumns();
                    List<String> statement = SqlStorageSupplier.this.toSaveStatement(name, keyColumns, valueColumns);
                    ArrayList values = new ArrayList();
                    map.forEach((key, value) -> {
                        Object[] keyValues = converter.toKeyQueryValues(key);
                        Object[] valueValues = converter.toValueQueryValues(value);
                        values.add(SqlStorageSupplier.this.toSaveValues(keyValues, valueValues));
                    });
                    for (int i = 0; i < statement.size(); ++i) {
                        BatchBuilder batchBuilder = BatchBuilder.create((Connection)connection, (String)statement.get(i));
                        for (List value2 : values) {
                            batchBuilder.addValues((Object[])value2.get(i));
                        }
                        batchBuilder.execute();
                    }
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to save top holder", (Throwable)e);
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Optional<V> load(K key) {
                Connection connection = null;
                try {
                    connection = SqlStorageSupplier.this.getConnection();
                    String[] keyColumns = converter.getKeyColumns();
                    Object[] keyValues = converter.toKeyQueryValues(key);
                    StringBuilder statement = new StringBuilder("SELECT * FROM `").append(name).append("` WHERE ");
                    for (int i = 0; i < keyColumns.length; ++i) {
                        statement.append("`").append(keyColumns[i]).append("` = ?");
                        if (i == keyColumns.length - 1) continue;
                        statement.append(" AND ");
                    }
                    Optional optional = (Optional)StatementBuilder.create((Connection)connection).setStatement(statement.toString()).addValues(keyValues).query(resultSet -> resultSet.next() ? Optional.of(converter.getValue(resultSet)) : Optional.empty());
                    return optional;
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load top holder", (Throwable)e);
                    Optional optional = Optional.empty();
                    return optional;
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove(Collection<K> keys) {
                Connection connection = null;
                try {
                    connection = SqlStorageSupplier.this.getConnection();
                    String[] keyColumns = converter.getKeyColumns();
                    StringBuilder statement = new StringBuilder("DELETE FROM `").append(name).append("` WHERE ");
                    for (int i = 0; i < keyColumns.length; ++i) {
                        statement.append("`").append(keyColumns[i]).append("` = ?");
                        if (i == keyColumns.length - 1) continue;
                        statement.append(" AND ");
                    }
                    BatchBuilder batchBuilder = BatchBuilder.create((Connection)connection, (String)statement.toString());
                    keys.forEach(key -> {
                        Object[] keyValues = converter.toKeyQueryValues(key);
                        batchBuilder.addValues(keyValues);
                    });
                    batchBuilder.execute();
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to remove top holder", (Throwable)e);
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegister() {
                Connection connection = null;
                try {
                    int i;
                    connection = SqlStorageSupplier.this.getConnection();
                    String[] keyColumns = converter.getKeyColumns();
                    String[] keyColumnDefinitions = converter.getKeyColumnDefinitions();
                    String[] valueColumnDefinitions = converter.getValueColumnDefinitions();
                    StringBuilder statement = new StringBuilder("CREATE TABLE IF NOT EXISTS `").append(name).append("` (");
                    for (i = 0; i < keyColumnDefinitions.length + valueColumnDefinitions.length; ++i) {
                        if (i < keyColumnDefinitions.length) {
                            statement.append(keyColumnDefinitions[i]);
                        } else {
                            statement.append(valueColumnDefinitions[i - keyColumnDefinitions.length]);
                        }
                        if (i == keyColumnDefinitions.length + valueColumnDefinitions.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(", PRIMARY KEY (");
                    for (i = 0; i < keyColumns.length; ++i) {
                        statement.append("`").append(keyColumns[i]).append("`");
                        if (i == keyColumns.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(")").append(");");
                    StatementBuilder.create((Connection)connection).setStatement(statement.toString()).update();
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to create table", (Throwable)e);
                }
                finally {
                    if (connection != null) {
                        SqlStorageSupplier.this.flushConnection(connection);
                    }
                }
            }
        };
    }
}

