/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.builder;

import java.util.function.Function;
import me.hsgamer.hscore.builder.Builder;
import me.hsgamer.topper.storage.simple.setting.DataStorageSetting;
import me.hsgamer.topper.storage.simple.supplier.DataStorageSupplier;
import me.hsgamer.topper.storage.simple.supplier.FlatStorageSupplier;
import me.hsgamer.topper.storage.simple.supplier.MySqlStorageSupplier;
import me.hsgamer.topper.storage.simple.supplier.NewSqliteStorageSupplier;
import me.hsgamer.topper.storage.simple.supplier.SqliteStorageSupplier;

public class DataStorageBuilder
extends Builder<DataStorageSetting, DataStorageSupplier> {
    private final Function<DataStorageSetting, DataStorageSupplier> defaultSupplier = setting -> new FlatStorageSupplier(setting.getBaseFolder());

    public DataStorageBuilder() {
        this.register(this.defaultSupplier, new String[]{"flat", "properties", ""});
        this.register(setting -> new SqliteStorageSupplier(setting.getDatabaseSettingModifier(), setting.getBaseFolder()), new String[]{"sqlite", "sqlite3"});
        this.register(setting -> new NewSqliteStorageSupplier(setting.getDatabaseSettingModifier(), setting.getBaseFolder()), new String[]{"new-sqlite", "new-sqlite3"});
        this.register(setting -> new MySqlStorageSupplier(setting.getDatabaseSettingModifier()), new String[]{"mysql", "mysql-connector-java", "mysql-connector"});
    }

    public DataStorageSupplier buildSupplier(String type, DataStorageSetting setting) {
        return this.build(type, setting).orElseGet(() -> this.defaultSupplier.apply(setting));
    }
}

