/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import me.hsgamer.topper.storage.simple.converter.ValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberConverter<T extends Number>
implements ValueConverter<T> {
    private final String valueName;
    private final boolean isDoubleValue;
    private final Function<@NotNull Number, @NotNull T> numberFunction;

    public NumberConverter(String valueName, boolean isDoubleValue, Function<@NotNull Number, @NotNull T> numberFunction) {
        this.valueName = valueName;
        this.isDoubleValue = isDoubleValue;
        this.numberFunction = numberFunction;
    }

    @Override
    @NotNull
    public String toRawString(@NotNull Number value) {
        return value.toString();
    }

    @Override
    @Nullable
    public T fromRawString(@NotNull String value) {
        try {
            return (T)((Number)this.numberFunction.apply(this.isDoubleValue ? Double.parseDouble(value) : (double)Long.parseLong(value)));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public Map<String, Object> toObjectMap(@NotNull Number value) {
        return Collections.singletonMap(this.valueName, value);
    }

    @Override
    @Nullable
    public T fromObjectMap(@NotNull Map<String, Object> map) {
        Number number;
        Object value = map.get(this.valueName);
        if (value instanceof Number) {
            number = (Number)value;
        } else {
            try {
                number = this.isDoubleValue ? Double.parseDouble(value.toString()) : (double)Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return (T)((Number)this.numberFunction.apply(number));
    }

    @Override
    public String[] getSqlColumns() {
        return new String[]{this.valueName};
    }

    @Override
    public String[] getSqlColumnDefinitions() {
        String columnType = this.isDoubleValue ? "DOUBLE" : "BIGINT";
        return new String[]{columnType + " NOT NULL"};
    }

    @Override
    public Object[] toSqlValues(@NotNull Number value) {
        return new Object[]{value};
    }

    @Override
    @Nullable
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        Double number = this.isDoubleValue ? resultSet.getDouble(this.valueName) : (double)resultSet.getLong(this.valueName);
        return (T)((Number)this.numberFunction.apply(number));
    }
}

