/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import me.hsgamer.topper.storage.simple.converter.ValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleValueConverter<T>
implements ValueConverter<T> {
    private final Function<@NotNull T, @NotNull String> toStringConverter;
    private final Function<@NotNull String, @Nullable T> fromStringConverter;
    private final String valueName;
    private final String sqlType;

    public SimpleValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, String sqlType) {
        this.toStringConverter = toStringConverter;
        this.fromStringConverter = fromStringConverter;
        this.valueName = valueName;
        this.sqlType = sqlType;
    }

    public SimpleValueConverter(Function<@NotNull T, @NotNull String> toStringConverter, Function<@NotNull String, @Nullable T> fromStringConverter, String valueName, boolean isStringNationalized, int stringMaxLength) {
        this(toStringConverter, fromStringConverter, valueName, (isStringNationalized ? "N" : "") + "VARCHAR(" + stringMaxLength + ")");
    }

    @Override
    @NotNull
    public String toRawString(@NotNull T value) {
        return this.toStringConverter.apply(value);
    }

    @Override
    @Nullable
    public T fromRawString(@NotNull String value) {
        return this.fromStringConverter.apply(value);
    }

    @Override
    @NotNull
    public Map<String, Object> toObjectMap(@NotNull T value) {
        return Collections.singletonMap(this.valueName, value);
    }

    @Override
    @Nullable
    public T fromObjectMap(@NotNull Map<String, Object> map) {
        Object value = map.get(this.valueName);
        return value == null ? null : (T)this.fromRawString(value.toString());
    }

    @Override
    public String[] getSqlColumns() {
        return new String[]{this.valueName};
    }

    @Override
    public String[] getSqlColumnDefinitions() {
        return new String[]{this.sqlType + " NOT NULL"};
    }

    @Override
    public Object[] toSqlValues(@NotNull T value) {
        return new Object[]{this.toRawString(value)};
    }

    @Override
    @Nullable
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        String value = resultSet.getString(this.valueName);
        return value == null ? null : (T)this.fromRawString(value);
    }
}

