/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.supplier;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.hsgamer.hscore.database.Driver;
import me.hsgamer.hscore.database.Setting;
import me.hsgamer.hscore.database.client.sql.BatchBuilder;
import me.hsgamer.hscore.database.client.sql.SqlClient;
import me.hsgamer.hscore.database.client.sql.StatementBuilder;
import me.hsgamer.hscore.database.client.sql.java.JavaSqlClient;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.simple.converter.ValueConverter;
import me.hsgamer.topper.storage.simple.setting.DatabaseSetting;
import me.hsgamer.topper.storage.simple.supplier.DataStorageSupplier;

public abstract class SqlStorageSupplier
implements DataStorageSupplier {
    protected final Logger logger = LoggerProvider.getLogger(this.getClass());
    private final SqlClient<?> client;
    private final Lock lock = new ReentrantLock();

    protected SqlStorageSupplier(SqlClient<?> client) {
        this.client = client;
    }

    protected SqlStorageSupplier(Driver driver, DatabaseSetting databaseSetting) {
        this((SqlClient<?>)new JavaSqlClient(SqlStorageSupplier.applyDatabaseSetting(databaseSetting, Setting.create((Driver)driver))));
    }

    protected static Setting applyDatabaseSetting(DatabaseSetting databaseSetting, Setting setting) {
        setting.setHost(databaseSetting.getHost());
        setting.setPort(databaseSetting.getPort());
        setting.setDatabaseName(databaseSetting.getDatabase());
        setting.setUsername(databaseSetting.getUsername());
        setting.setPassword(databaseSetting.getPassword());
        if (databaseSetting.isUseSSL()) {
            setting.setDriverProperty("useSSL", (Object)"true");
        }
        setting.setDriverProperties(databaseSetting.getDriverProperties());
        setting.setClientProperties(databaseSetting.getClientProperties());
        return setting;
    }

    protected boolean isSingleThread() {
        return false;
    }

    protected abstract List<String> toSaveStatement(String var1, String[] var2, String[] var3);

    protected abstract List<Object[]> toSaveValues(Object[] var1, Object[] var2);

    private void lock() {
        if (this.isSingleThread()) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.isSingleThread()) {
            this.lock.unlock();
        }
    }

    @Override
    public <K, V> DataStorage<K, V> getStorage(final String name, final ValueConverter<K> keyConverter, final ValueConverter<V> valueConverter) {
        return new DataStorage<K, V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Map<K, V> load() {
                SqlStorageSupplier.this.lock();
                try {
                    Map<Object, Object> map;
                    block11: {
                        Connection connection = SqlStorageSupplier.this.client.getConnection();
                        try {
                            map = StatementBuilder.create((Connection)connection).setStatement("SELECT * FROM `" + name + "`;").queryList(resultSet -> new AbstractMap.SimpleEntry(keyConverter.fromSqlResultSet(resultSet), valueConverter.fromSqlResultSet(resultSet))).stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                            if (connection == null) break block11;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException e) {
                                SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load top holder", (Throwable)e);
                                Map map2 = Collections.emptyMap();
                                return map2;
                            }
                        }
                        connection.close();
                    }
                    return map;
                }
                finally {
                    SqlStorageSupplier.this.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Optional<V> load(K key) {
                SqlStorageSupplier.this.lock();
                try {
                    Optional optional;
                    block12: {
                        Connection connection = SqlStorageSupplier.this.client.getConnection();
                        try {
                            String[] keyColumns = keyConverter.getSqlColumns();
                            Object[] keyValues = keyConverter.toSqlValues(key);
                            StringBuilder statement = new StringBuilder("SELECT * FROM `").append(name).append("` WHERE ");
                            for (int i = 0; i < keyColumns.length; ++i) {
                                statement.append("`").append(keyColumns[i]).append("` = ?");
                                if (i == keyColumns.length - 1) continue;
                                statement.append(" AND ");
                            }
                            optional = (Optional)StatementBuilder.create((Connection)connection).setStatement(statement.toString()).addValues(keyValues).query(resultSet -> resultSet.next() ? Optional.ofNullable(valueConverter.fromSqlResultSet(resultSet)) : Optional.empty());
                            if (connection == null) break block12;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException e) {
                                SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to load top holder", (Throwable)e);
                                Optional optional2 = Optional.empty();
                                return optional2;
                            }
                        }
                        connection.close();
                    }
                    return optional;
                }
                finally {
                    SqlStorageSupplier.this.unlock();
                }
            }

            public Optional<DataStorage.Modifier<K, V>> modify() {
                SqlStorageSupplier.this.lock();
                try {
                    final Connection connection = SqlStorageSupplier.this.client.getConnection();
                    connection.setAutoCommit(false);
                    DataStorage.Modifier modifier = new DataStorage.Modifier<K, V>(){

                        public void save(Map<K, V> map) throws SQLException {
                            String[] keyColumns = keyConverter.getSqlColumns();
                            String[] valueColumns = valueConverter.getSqlColumns();
                            List<String> statement = SqlStorageSupplier.this.toSaveStatement(name, keyColumns, valueColumns);
                            ArrayList values = new ArrayList();
                            map.forEach((key, value) -> {
                                Object[] keyValues = keyConverter.toSqlValues(key);
                                Object[] valueValues = valueConverter.toSqlValues(value);
                                values.add(SqlStorageSupplier.this.toSaveValues(keyValues, valueValues));
                            });
                            for (int i = 0; i < statement.size(); ++i) {
                                BatchBuilder batchBuilder = BatchBuilder.create((Connection)connection, (String)statement.get(i));
                                for (List value2 : values) {
                                    batchBuilder.addValues((Object[])value2.get(i));
                                }
                                batchBuilder.execute();
                            }
                        }

                        public void remove(Collection<K> keys) throws SQLException {
                            String[] keyColumns = keyConverter.getSqlColumns();
                            StringBuilder statement = new StringBuilder("DELETE FROM `").append(name).append("` WHERE ");
                            for (int i = 0; i < keyColumns.length; ++i) {
                                statement.append("`").append(keyColumns[i]).append("` = ?");
                                if (i == keyColumns.length - 1) continue;
                                statement.append(" AND ");
                            }
                            BatchBuilder batchBuilder = BatchBuilder.create((Connection)connection, (String)statement.toString());
                            keys.forEach(key -> {
                                Object[] keyValues = keyConverter.toSqlValues(key);
                                batchBuilder.addValues(keyValues);
                            });
                            batchBuilder.execute();
                        }

                        private void close() {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to close connection", (Throwable)e);
                            }
                        }

                        public void commit() {
                            try {
                                connection.commit();
                            }
                            catch (SQLException e) {
                                SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to commit", (Throwable)e);
                            }
                            finally {
                                this.close();
                                SqlStorageSupplier.this.unlock();
                            }
                        }

                        public void rollback() {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException e) {
                                SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to rollback", (Throwable)e);
                            }
                            finally {
                                this.close();
                                SqlStorageSupplier.this.unlock();
                            }
                        }
                    };
                    return Optional.of(modifier);
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to get connection", (Throwable)e);
                    SqlStorageSupplier.this.unlock();
                    return Optional.empty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRegister() {
                SqlStorageSupplier.this.lock();
                try (Connection connection = SqlStorageSupplier.this.client.getConnection();){
                    int i;
                    String[] keyColumns = keyConverter.getSqlColumns();
                    String[] keyColumnDefinitions = keyConverter.getSqlColumnDefinitions();
                    String[] valueColumns = valueConverter.getSqlColumns();
                    String[] valueColumnDefinitions = valueConverter.getSqlColumnDefinitions();
                    StringBuilder statement = new StringBuilder("CREATE TABLE IF NOT EXISTS `").append(name).append("` (");
                    for (i = 0; i < keyColumns.length + valueColumns.length; ++i) {
                        boolean isKey = i < keyColumns.length;
                        int index = isKey ? i : i - keyColumns.length;
                        statement.append("`").append(isKey ? keyColumns[index] : valueColumns[index]).append("` ").append(isKey ? keyColumnDefinitions[index] : valueColumnDefinitions[index]);
                        if (i == keyColumns.length + valueColumns.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(", PRIMARY KEY (");
                    for (i = 0; i < keyColumns.length; ++i) {
                        statement.append("`").append(keyColumns[i]).append("`");
                        if (i == keyColumns.length - 1) continue;
                        statement.append(", ");
                    }
                    statement.append(")").append(");");
                    StatementBuilder.create((Connection)connection).setStatement(statement.toString()).update();
                }
                catch (SQLException e) {
                    SqlStorageSupplier.this.logger.log(LogLevel.ERROR, "Failed to create table", (Throwable)e);
                }
                finally {
                    SqlStorageSupplier.this.unlock();
                }
            }
        };
    }
}

