/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.storage.simple.supplier;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import me.hsgamer.hscore.database.Driver;
import me.hsgamer.hscore.database.driver.sqlite.SqliteFileDriver;
import me.hsgamer.topper.storage.simple.setting.DatabaseSetting;
import me.hsgamer.topper.storage.simple.supplier.SqlStorageSupplier;

public class SqliteStorageSupplier
extends SqlStorageSupplier {
    public SqliteStorageSupplier(DatabaseSetting databaseSetting, File baseHolder) {
        super((Driver)new SqliteFileDriver(baseHolder), databaseSetting);
    }

    @Override
    protected boolean isSingleThread() {
        return true;
    }

    @Override
    protected List<String> toSaveStatement(String name, String[] keyColumns, String[] valueColumns) {
        int i;
        int i2;
        StringBuilder insertStatement = new StringBuilder("INSERT OR IGNORE INTO `").append(name).append("` (");
        for (i2 = 0; i2 < keyColumns.length + valueColumns.length; ++i2) {
            insertStatement.append("`").append(i2 < keyColumns.length ? keyColumns[i2] : valueColumns[i2 - keyColumns.length]).append("`");
            if (i2 == keyColumns.length + valueColumns.length - 1) continue;
            insertStatement.append(", ");
        }
        insertStatement.append(") VALUES (");
        for (i2 = 0; i2 < keyColumns.length + valueColumns.length; ++i2) {
            insertStatement.append("?");
            if (i2 == keyColumns.length + valueColumns.length - 1) continue;
            insertStatement.append(", ");
        }
        insertStatement.append(");");
        StringBuilder updateStatement = new StringBuilder("UPDATE `").append(name).append("` SET ");
        for (i = 0; i < valueColumns.length; ++i) {
            updateStatement.append("`").append(valueColumns[i]).append("` = ?");
            if (i == valueColumns.length - 1) continue;
            updateStatement.append(", ");
        }
        updateStatement.append(" WHERE ");
        for (i = 0; i < keyColumns.length; ++i) {
            updateStatement.append("`").append(keyColumns[i]).append("` = ?");
            if (i == keyColumns.length - 1) continue;
            updateStatement.append(" AND ");
        }
        updateStatement.append(";");
        return Arrays.asList(insertStatement.toString(), updateStatement.toString());
    }

    @Override
    protected List<Object[]> toSaveValues(Object[] keys, Object[] values) {
        Object[] insertValues = new Object[keys.length + values.length];
        System.arraycopy(keys, 0, insertValues, 0, keys.length);
        System.arraycopy(values, 0, insertValues, keys.length, values.length);
        Object[] updateValues = new Object[values.length + keys.length];
        System.arraycopy(values, 0, updateValues, 0, values.length);
        System.arraycopy(keys, 0, updateValues, values.length, keys.length);
        return Arrays.asList(insertValues, updateValues);
    }
}

