/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.template.topplayernumber.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import me.hsgamer.topper.data.core.DataEntry;
import me.hsgamer.topper.template.topplayernumber.TopPlayerNumberTemplate;
import org.jetbrains.annotations.Nullable;

public class EntryConsumeManager {
    private final TopPlayerNumberTemplate template;
    private final List<Consumer<Context>> consumerList = new ArrayList<Consumer<Context>>();
    private final Map<String, BiFunction<String, UUID, Optional<Double>>> providerMap = new HashMap<String, BiFunction<String, UUID, Optional<Double>>>();

    public EntryConsumeManager(TopPlayerNumberTemplate template) {
        this.template = template;
    }

    public Runnable addConsumer(Consumer<Context> consumer) {
        this.consumerList.add(consumer);
        return () -> this.consumerList.remove(consumer);
    }

    public Runnable addConsumer(String group, String holder, BiConsumer<UUID, Double> consumer) {
        return this.addConsumer(context -> {
            if (Objects.equals(context.group, group) && Objects.equals(context.holder, holder)) {
                consumer.accept(context.uuid, context.value);
            }
        });
    }

    public Runnable addProvider(String group, BiFunction<String, UUID, Optional<Double>> provider) {
        this.providerMap.put(group, provider);
        return () -> this.providerMap.remove(group);
    }

    public Optional<Double> getValue(String group, String holder, UUID uuid) {
        BiFunction<String, UUID, Optional<Double>> function = this.providerMap.get(group);
        return function == null ? Optional.empty() : function.apply(holder, uuid);
    }

    public void consume(Context context) {
        this.consumerList.forEach(consumer -> consumer.accept(context));
    }

    public void enable() {
        this.addProvider("topper", (holder, uuid) -> this.template.getTopManager().getHolder((String)holder).flatMap(h -> h.getEntry(uuid)).map(DataEntry::getValue));
    }

    public void disable() {
        this.consumerList.clear();
        this.providerMap.clear();
    }

    public static class Context {
        public final String group;
        public final String holder;
        public final UUID uuid;
        @Nullable
        public final Double oldValue;
        @Nullable
        public final Double value;

        public Context(String group, String holder, UUID uuid, @Nullable Double oldValue, @Nullable Double value) {
            this.group = group;
            this.holder = holder;
            this.uuid = uuid;
            this.oldValue = oldValue;
            this.value = value;
        }
    }
}

