/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.topper.template.topplayernumber.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.topper.agent.core.AgentHolder;
import me.hsgamer.topper.storage.core.DataStorage;
import me.hsgamer.topper.storage.flat.converter.NumberFlatValueConverter;
import me.hsgamer.topper.storage.flat.converter.UUIDFlatValueConverter;
import me.hsgamer.topper.storage.sql.converter.NumberSqlValueConverter;
import me.hsgamer.topper.storage.sql.converter.UUIDSqlValueConverter;
import me.hsgamer.topper.template.topplayernumber.TopPlayerNumberTemplate;
import me.hsgamer.topper.template.topplayernumber.holder.NumberTopHolder;
import me.hsgamer.topper.template.topplayernumber.storage.DataStorageSupplier;

public class TopManager {
    private final Map<String, NumberTopHolder> holders = new HashMap<String, NumberTopHolder>();
    private final TopPlayerNumberTemplate template;
    private DataStorageSupplier storageSupplier;

    public TopManager(TopPlayerNumberTemplate template) {
        this.template = template;
    }

    public void enable() {
        this.storageSupplier = this.template.getDataStorageSupplier(this.template.getSettings().storageType(), this.template.getSettings());
        this.template.getSettings().holders().forEach((key, value) -> {
            NumberTopHolder topHolder = new NumberTopHolder(this.template, (String)key, (NumberTopHolder.Settings)value);
            topHolder.register();
            this.holders.put((String)key, topHolder);
        });
    }

    public void disable() {
        this.holders.values().forEach(AgentHolder::unregister);
        this.holders.clear();
    }

    public DataStorageSupplier getStorageSupplier() {
        return this.storageSupplier;
    }

    public DataStorage<UUID, Double> buildStorage(String name) {
        return this.storageSupplier.getStorage(name, new UUIDFlatValueConverter(), new NumberFlatValueConverter(Number::doubleValue), new UUIDSqlValueConverter("uuid"), new NumberSqlValueConverter("value", true, Number::doubleValue));
    }

    public Optional<NumberTopHolder> getHolder(String name) {
        return Optional.ofNullable(this.holders.get(name));
    }

    public List<String> getHolderNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.holders.keySet()));
    }

    public void create(UUID uuid) {
        this.holders.values().forEach(holder -> holder.getOrCreateEntry(uuid));
    }
}

